"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionFindResponseRt = exports.UserActionFindRequestRt = exports.CaseUserActionsDeprecatedResponseRt = exports.CaseUserActionStatsRt = exports.CaseUserActionStatsResponseRt = exports.CaseUserActionDeprecatedResponseRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _schema = require("../../../schema");
var _constants = require("../../../constants");
var _v = require("../../domain/user_action/action/v1");
var _v2 = require("../../domain/user_action/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * User actions stats API
 */
const CaseUserActionStatsRt = rt.strict({
  total: rt.number,
  total_comments: rt.number,
  total_other_actions: rt.number
});
exports.CaseUserActionStatsRt = CaseUserActionStatsRt;
const CaseUserActionStatsResponseRt = CaseUserActionStatsRt;

/**
 * Deprecated APIs
 */
exports.CaseUserActionStatsResponseRt = CaseUserActionStatsResponseRt;
const CaseUserActionDeprecatedResponseRt = rt.intersection([_v2.CaseUserActionBasicRt, _v2.CaseUserActionInjectedDeprecatedIdsRt]);
exports.CaseUserActionDeprecatedResponseRt = CaseUserActionDeprecatedResponseRt;
const CaseUserActionsDeprecatedResponseRt = rt.array(CaseUserActionDeprecatedResponseRt);
exports.CaseUserActionsDeprecatedResponseRt = CaseUserActionsDeprecatedResponseRt;
/**
 * Find User Actions API
 */

const UserActionAdditionalFindRequestFilterTypes = {
  action: 'action',
  alert: 'alert',
  user: 'user',
  attachment: 'attachment'
};
const UserActionFindRequestTypes = {
  ..._v.UserActionTypes,
  ...UserActionAdditionalFindRequestFilterTypes
};
const UserActionFindRequestTypesRt = rt.keyof(UserActionFindRequestTypes);
const UserActionFindRequestRt = rt.intersection([rt.exact(rt.partial({
  types: rt.array(UserActionFindRequestTypesRt),
  sortOrder: rt.union([rt.literal('desc'), rt.literal('asc')])
})), (0, _schema.paginationSchema)({
  maxPerPage: _constants.MAX_USER_ACTIONS_PER_PAGE
})]);
exports.UserActionFindRequestRt = UserActionFindRequestRt;
const UserActionFindResponseRt = rt.strict({
  userActions: _v2.UserActionsRt,
  page: rt.number,
  perPage: rt.number,
  total: rt.number
});
exports.UserActionFindResponseRt = UserActionFindResponseRt;