"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throwErrors = exports.throwBadRequestError = exports.jsonValueRt = exports.jsonScalarRt = exports.jsonObjectRt = exports.jsonArrayRt = exports.decodeWithExcessOrThrow = exports.decodeOrThrow = exports.createPlainError = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _exact_check = require("@kbn/securitysolution-io-ts-utils/src/exact_check");
var _format_errors = require("@kbn/securitysolution-io-ts-utils/src/format_errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPlainError = message => new Error(message);
exports.createPlainError = createPlainError;
const throwErrors = createError => errors => {
  throw createError((0, _format_errors.formatErrors)(errors).join());
};
exports.throwErrors = throwErrors;
const throwBadRequestError = errors => {
  throw _boom.default.badRequest((0, _format_errors.formatErrors)(errors).join());
};

/**
 * This function will throw if a required field is missing or an excess field is present.
 * NOTE: This will only throw for an excess field if the type passed in leverages exact from io-ts.
 */
exports.throwBadRequestError = throwBadRequestError;
const decodeWithExcessOrThrow = runtimeType => inputValue => (0, _pipeable.pipe)(runtimeType.decode(inputValue), decoded => (0, _exact_check.exactCheck)(inputValue, decoded), (0, _Either.fold)(throwBadRequestError, _function.identity));

/**
 * This function will throw if a required field is missing.
 */
exports.decodeWithExcessOrThrow = decodeWithExcessOrThrow;
const decodeOrThrow = (runtimeType, createError = createPlainError) => inputValue => (0, _pipeable.pipe)(runtimeType.decode(inputValue), (0, _Either.fold)(throwErrors(createError), _function.identity));
exports.decodeOrThrow = decodeOrThrow;
const jsonScalarRt = rt.union([rt.null, rt.boolean, rt.number, rt.string]);
exports.jsonScalarRt = jsonScalarRt;
const jsonValueRt = rt.recursion('JsonValue', () => rt.union([jsonScalarRt, jsonArrayRt, jsonObjectRt]));
exports.jsonValueRt = jsonValueRt;
const jsonArrayRt = rt.recursion('JsonArray', () => rt.array(jsonValueRt));
exports.jsonArrayRt = jsonArrayRt;
const jsonObjectRt = rt.recursion('JsonObject', () => rt.record(rt.string, jsonValueRt));
exports.jsonObjectRt = jsonObjectRt;