"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reportingServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reportingServiceFactory = (_coreSetup, coreStart, _setupPlugins, startPlugins) => {
  const {
    reporting
  } = startPlugins;
  const reportingEnabled = () => ({
    start: reporting
  });
  const reportingDisabled = () => ({
    start: undefined
  });
  if (!reporting) {
    // Reporting is not enabled
    return reportingDisabled();
  }
  if (reporting.usesUiCapabilities()) {
    var _coreStart$applicatio;
    if (((_coreStart$applicatio = coreStart.application.capabilities.canvas) === null || _coreStart$applicatio === void 0 ? void 0 : _coreStart$applicatio.generatePdf) === true) {
      // Canvas has declared Reporting as a subfeature with the `generatePdf` UI Capability
      return reportingEnabled();
    } else {
      return reportingDisabled();
    }
  }

  // Legacy/Deprecated: Reporting is enabled as an Elasticsearch feature
  return reportingEnabled();
};
exports.reportingServiceFactory = reportingServiceFactory;