"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  CanvasServiceProvider: true,
  services: true,
  startLegacyServices: true,
  stopServices: true,
  searchService: true,
  ExpressionsService: true
};
exports.CanvasServiceProvider = void 0;
Object.defineProperty(exports, "ExpressionsService", {
  enumerable: true,
  get: function () {
    return _common.ExpressionsService;
  }
});
exports.stopServices = exports.startLegacyServices = exports.services = exports.searchService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _search = require("./search");
var _common = require("@kbn/expressions-plugin/common");
var _context = require("./context");
Object.keys(_context).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _context[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _context[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CanvasServiceProvider {
  constructor(factory) {
    (0, _defineProperty2.default)(this, "factory", void 0);
    (0, _defineProperty2.default)(this, "service", void 0);
    this.factory = factory;
  }
  setService(service) {
    this.service = service;
  }
  async start(coreSetup, coreStart, canvasSetupPlugins, canvasStartPlugins, appUpdater) {
    this.service = await this.factory(coreSetup, coreStart, canvasSetupPlugins, canvasStartPlugins, appUpdater);
  }
  getService() {
    if (!this.service) {
      throw new Error('Service not ready');
    }
    return this.service;
  }
  stop() {
    this.service = undefined;
  }
}
exports.CanvasServiceProvider = CanvasServiceProvider;
const services = {
  search: new CanvasServiceProvider(_search.searchServiceFactory)
};
exports.services = services;
const startLegacyServices = async (coreSetup, coreStart, canvasSetupPlugins, canvasStartPlugins, appUpdater) => {
  const startPromises = Object.values(services).map(provider => provider.start(coreSetup, coreStart, canvasSetupPlugins, canvasStartPlugins, appUpdater));
  await Promise.all(startPromises);
};
exports.startLegacyServices = startLegacyServices;
const stopServices = () => {
  Object.values(services).forEach(provider => provider.stop());
};
exports.stopServices = stopServices;
const {
  search: searchService
} = services;
exports.searchService = searchService;