"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSimpleArg = getSimpleArg;
exports.setSimpleArg = setSimpleArg;
exports.validateArg = validateArg;
var _lodash = require("lodash");
var _interpreter = require("@kbn/interpreter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*

  IMPORTANT: These only work with simple values, eg string, number, boolean.
  Getting or setting anything else will throw.

*/ // TODO: With the removal of objectified literals in the AST I don't think we need this anymore.
const allowedTypes = ['string', 'number', 'boolean'];
const badType = () => new Error(`Arg setting helpers only support ${allowedTypes.join(',')}`);
const isAllowed = type => (0, _lodash.includes)(allowedTypes, type);
function validateArg(value) {
  const type = (0, _interpreter.getType)(value);
  if (!isAllowed(type)) {
    throw badType();
  }
  return value;
}
function getSimpleArg(name, args) {
  if (!args[name]) {
    return [];
  }
  return args[name].map(astVal => {
    if (!isAllowed((0, _interpreter.getType)(astVal))) {
      throw badType();
    }
    return astVal;
  });
}
function setSimpleArg(name, value) {
  value = Array.isArray(value) ? value : [value];
  return {
    [name]: value.map(validateArg)
  };
}