"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FormatSelect extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isCustomFormat: !this.props.formatOptions.map(({
        value
      }) => value).includes(this.props.argValue)
    });
    (0, _defineProperty2.default)(this, "_options", this.props.formatOptions.concat({
      value: 'custom',
      text: 'Custom'
    }));
    (0, _defineProperty2.default)(this, "_handleTextChange", ev => this.props.onValueChange(ev.target.value));
    (0, _defineProperty2.default)(this, "_handleSelectChange", ev => {
      const {
        onValueChange,
        defaultCustomFormat
      } = this.props;
      const {
        value
      } = this._options[ev.target.selectedIndex];
      if (value === 'custom') {
        this.setState({
          isCustomFormat: true
        });
        return onValueChange(defaultCustomFormat);
      }
      if (this.state.isCustomFormat) {
        this.setState({
          isCustomFormat: false
        });
      }
      return onValueChange(value);
    });
  }
  render() {
    const {
      argId,
      argValue,
      defaultCustomFormat
    } = this.props;
    const {
      isCustomFormat
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      compressed: true,
      id: argId,
      value: isCustomFormat ? 'custom' : argValue,
      options: this._options,
      onChange: this._handleSelectChange
    }), isCustomFormat && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      placeholder: defaultCustomFormat,
      value: argValue,
      compressed: true,
      onChange: this._handleTextChange
    })));
  }
}
exports.FormatSelect = FormatSelect;
(0, _defineProperty2.default)(FormatSelect, "propTypes", {
  argId: _propTypes.default.string,
  argValue: _propTypes.default.string,
  formatOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.string,
    text: _propTypes.default.string
  })).isRequired,
  onValueChange: _propTypes.default.func
});