"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgTemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _expression_form_handlers = require("../../../common/lib/expression_form_handlers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mergeWithFormHandlers = handlers => Object.assign(new _expression_form_handlers.ExpressionFormHandlers(), handlers);
const ArgTemplateFormComponent = ({
  template,
  argumentProps,
  handlers,
  error,
  errorTemplate
}) => {
  const [updatedHandlers, setHandlers] = (0, _react.useState)(mergeWithFormHandlers(handlers));
  const prevError = (0, _usePrevious.default)(error);
  const [argument, setArgument] = (0, _react.useState)();
  const mountedArgumentRef = (0, _react.useRef)();
  const domNodeRef = (0, _react.useRef)(null);
  (0, _useEffectOnce.default)(() => () => {
    mountedArgumentRef.current = undefined;
  });
  const onMount = (0, _react.useCallback)(ref => {
    if (!mountedArgumentRef.current && ref) {
      mountedArgumentRef.current = ref;
    }
  }, []);
  const renderTemplate = (0, _react.useCallback)(domNode => template && template(domNode, argumentProps, updatedHandlers, onMount), [argumentProps, onMount, template, updatedHandlers]);
  const renderErrorTemplate = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(errorTemplate, argumentProps), [errorTemplate, argumentProps]);
  (0, _react.useEffect)(() => {
    if (!argument && domNodeRef.current) {
      const arg = renderTemplate(domNodeRef.current);
      if (arg) {
        setArgument(arg);
      }
    }
  }, [argument, renderTemplate]);
  (0, _react.useEffect)(() => {
    setHandlers(mergeWithFormHandlers(handlers));
  }, [handlers]);
  (0, _react.useEffect)(() => {
    if (mountedArgumentRef.current) {
      var _mountedArgumentRef$c;
      (_mountedArgumentRef$c = mountedArgumentRef.current) === null || _mountedArgumentRef$c === void 0 ? void 0 : _mountedArgumentRef$c.updateProps(argumentProps);
    }
  }, [argumentProps]);
  (0, _react.useEffect)(() => {
    if (!prevError && error) {
      updatedHandlers.destroy();
    }
  }, [prevError, error, updatedHandlers]);
  if (error) {
    mountedArgumentRef.current = undefined;
    return renderErrorTemplate();
  }
  if (!template) {
    mountedArgumentRef.current = undefined;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "render_to_dom",
    ref: domNodeRef
  }, argument);
};
const ArgTemplateForm = /*#__PURE__*/(0, _react.memo)(ArgTemplateFormComponent, (prevProps, nextProps) => (0, _reactFastCompare.default)(prevProps, nextProps));
exports.ArgTemplateForm = ArgTemplateForm;