"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _shortcut_manager = require("../../lib/shortcut_manager");
var _routes = require("../../routes");
var _flyouts = require("../flyouts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

class ShortcutManagerContextWrapper extends _react.default.Component {
  getChildContext() {
    return {
      shortcuts: _shortcut_manager.shortcutManager
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.props.children);
  }
}
(0, _defineProperty2.default)(ShortcutManagerContextWrapper, "childContextTypes", {
  shortcuts: _propTypes.default.object.isRequired
});
const App = ({
  history
}) => {
  const {
    updatePath
  } = (0, _services.useNavLinkService)();
  (0, _react.useEffect)(() => {
    return history.listen(({
      pathname,
      search
    }) => {
      updatePath(pathname + search);
    });
  });
  return /*#__PURE__*/_react.default.createElement(ShortcutManagerContextWrapper, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvas canvasContainer"
  }, /*#__PURE__*/_react.default.createElement(_routes.CanvasRouter, {
    history: history
  }), /*#__PURE__*/_react.default.createElement(_flyouts.Flyouts, null)));
};
exports.App = App;