"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.AssetManagerServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _manage_index_templates = require("./lib/manage_index_templates");
var _routes = require("./routes");
var _assets_template = require("./templates/assets_template");
var _asset_client = require("./lib/asset_client");
var _config = require("../common/config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const config = {
  schema: _config.configSchema,
  exposeToBrowser: _config.exposeToBrowserConfig
};
exports.config = config;
class AssetManagerServerPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.config = context.config.get();
    this.logger = context.logger.get();
  }
  setup(core, plugins) {
    // Check for config value and bail out if not "alpha-enabled"
    if (!this.config.alphaEnabled) {
      this.logger.info('Server is NOT enabled');
      return;
    }
    this.logger.info('Server is enabled');
    const assetClient = new _asset_client.AssetClient({
      sourceIndices: this.config.sourceIndices,
      getApmIndices: plugins.apmDataAccess.getApmIndices,
      metricsClient: plugins.metricsDataAccess.client
    });
    const router = core.http.createRouter();
    (0, _routes.setupRoutes)({
      router,
      assetClient
    });
    return {
      assetClient
    };
  }
  start(core) {
    // Check for config value and bail out if not "alpha-enabled"
    if (!this.config.alphaEnabled) {
      return;
    }
    (0, _manage_index_templates.upsertTemplate)({
      esClient: core.elasticsearch.client.asInternalUser,
      template: _assets_template.assetsIndexTemplateConfig,
      logger: this.logger
    });
    return {};
  }
  stop() {}
}
exports.AssetManagerServerPlugin = AssetManagerServerPlugin;