"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GET_SERVICES = exports.GET_RELATED_ASSETS = exports.GET_PODS = exports.GET_HOSTS = exports.GET_CONTAINERS = exports.GET_ASSETS_DIFF = exports.GET_ASSETS = exports.ASSET_MANAGER_API_BASE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_MANAGER_API_BASE = '/api/asset-manager';
exports.ASSET_MANAGER_API_BASE = ASSET_MANAGER_API_BASE;
function base(path) {
  return `${ASSET_MANAGER_API_BASE}${path}`;
}
const GET_ASSETS = base('/assets');
exports.GET_ASSETS = GET_ASSETS;
const GET_RELATED_ASSETS = base('/assets/related');
exports.GET_RELATED_ASSETS = GET_RELATED_ASSETS;
const GET_ASSETS_DIFF = base('/assets/diff');
exports.GET_ASSETS_DIFF = GET_ASSETS_DIFF;
const GET_HOSTS = base('/assets/hosts');
exports.GET_HOSTS = GET_HOSTS;
const GET_SERVICES = base('/assets/services');
exports.GET_SERVICES = GET_SERVICES;
const GET_CONTAINERS = base('/assets/containers');
exports.GET_CONTAINERS = GET_CONTAINERS;
const GET_PODS = base('/assets/pods');
exports.GET_PODS = GET_PODS;