"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assistantRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _get_apm_alerts_client = require("../../lib/helpers/get_apm_alerts_client");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _get_ml_client = require("../../lib/helpers/get_ml_client");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _get_apm_correlation_values = require("./get_apm_correlation_values");
var _get_apm_downstream_dependencies = require("./get_apm_downstream_dependencies");
var _get_apm_service_summary = require("./get_apm_service_summary");
var _get_apm_timeseries = require("./get_apm_timeseries");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApmTimeSeriesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/assistant/get_apm_timeseries',
  options: {
    tags: ['access:apm', 'access:ai_assistant']
  },
  params: t.type({
    body: _get_apm_timeseries.getApmTimeseriesRt
  }),
  handler: async resources => {
    const body = resources.params.body;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const timeseries = await (0, _get_apm_timeseries.getApmTimeseries)({
      apmEventClient,
      arguments: body
    });
    return {
      content: timeseries.map(series => (0, _lodash.omit)(series, 'data')),
      data: timeseries
    };
  }
});
const getApmServiceSummaryRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/assistant/get_service_summary',
  options: {
    tags: ['access:apm', 'access:ai_assistant']
  },
  params: t.type({
    query: _get_apm_service_summary.serviceSummaryRouteRt
  }),
  handler: async resources => {
    const args = resources.params.query;
    const {
      context,
      request,
      plugins,
      logger
    } = resources;
    const [apmEventClient, annotationsClient, esClient, apmAlertsClient, mlClient] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), plugins.observability.setup.getScopedAnnotationsClient(context, request), context.core.then(coreContext => coreContext.elasticsearch.client.asCurrentUser), (0, _get_apm_alerts_client.getApmAlertsClient)(resources), (0, _get_ml_client.getMlClient)(resources)]);
    return {
      content: await (0, _get_apm_service_summary.getApmServiceSummary)({
        apmEventClient,
        annotationsClient,
        esClient,
        apmAlertsClient,
        mlClient,
        logger,
        arguments: args
      })
    };
  }
});
const getDownstreamDependenciesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/assistant/get_downstream_dependencies',
  params: t.type({
    query: _get_apm_downstream_dependencies.downstreamDependenciesRouteRt
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      query
    } = params;
    return {
      content: await (0, _get_apm_downstream_dependencies.getAssistantDownstreamDependencies)({
        arguments: query,
        apmEventClient
      })
    };
  }
});
const getApmCorrelationValuesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/assistant/get_correlation_values',
  params: t.type({
    body: _get_apm_correlation_values.correlationValuesRouteRt
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      body
    } = params;
    return {
      content: await (0, _get_apm_correlation_values.getApmCorrelationValues)({
        arguments: body,
        apmEventClient
      })
    };
  }
});
const assistantRouteRepository = {
  ...getApmTimeSeriesRoute,
  ...getApmServiceSummaryRoute,
  ...getApmCorrelationValuesRoute,
  ...getDownstreamDependenciesRoute
};
exports.assistantRouteRepository = assistantRouteRepository;