"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSeries = fetchSeries;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchSeries({
  apmEventClient,
  operationName,
  documentType,
  rollupInterval,
  intervalString,
  start,
  end,
  filter,
  groupBy,
  aggs,
  unit
}) {
  var _response$aggregation;
  const response = await apmEventClient.search(operationName, {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    body: {
      size: 0,
      track_total_hits: false,
      query: {
        bool: {
          filter
        }
      },
      aggs: {
        groupBy: {
          ...(groupBy ? {
            terms: {
              field: groupBy,
              size: 20
            }
          } : {
            terms: {
              field: 'non_existing_field',
              missing: ''
            }
          }),
          aggs: {
            ...aggs,
            timeseries: {
              date_histogram: {
                field: '@timestamp',
                fixed_interval: intervalString,
                min_doc_count: 0,
                extended_bounds: {
                  min: start,
                  max: end
                }
              },
              aggs
            },
            change_point: {
              change_point: {
                buckets_path: 'timeseries>value'
              }
            }
          }
        }
      }
    }
  });
  if (!((_response$aggregation = response.aggregations) !== null && _response$aggregation !== void 0 && _response$aggregation.groupBy)) {
    return [];
  }
  return response.aggregations.groupBy.buckets.map(bucket => {
    var _bucket$value, _bucket$value2;
    let value = ((_bucket$value = bucket.value) === null || _bucket$value === void 0 ? void 0 : _bucket$value.value) === undefined || ((_bucket$value2 = bucket.value) === null || _bucket$value2 === void 0 ? void 0 : _bucket$value2.value) === null ? null : Number(bucket.value.value);
    if (value !== null) {
      value = Math.abs(value) < 100 ? Number(value.toPrecision(3)) : Math.round(value);
    }
    return {
      groupBy: bucket.key_as_string || String(bucket.key),
      data: bucket.timeseries.buckets,
      value,
      change_point: bucket.change_point,
      unit
    };
  });
}