"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.correlationValuesRouteRt = void 0;
exports.getApmCorrelationValues = getApmCorrelationValues;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _common = require("@kbn/observability-plugin/common");
var _server = require("@kbn/observability-plugin/server");
var t = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../../common/assistant/constants");
var _apm = require("../../../../common/es_fields/apm");
var _term_query = require("../../../../common/utils/term_query");
var _default_api_types = require("../../default_api_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setRt = t.intersection([t.type({
  start: t.string,
  end: t.string,
  'service.name': t.string,
  label: t.string
}), t.partial({
  filter: t.string,
  'service.environment': _default_api_types.environmentRt.props.environment
})]);
const correlationValuesRouteRt = t.type({
  sets: t.array(t.type({
    foreground: setRt,
    background: setRt,
    event: t.union([t.literal(_constants.CorrelationsEventType.Transaction), t.literal(_constants.CorrelationsEventType.ExitSpan), t.literal(_constants.CorrelationsEventType.Error)])
  }))
});
exports.correlationValuesRouteRt = correlationValuesRouteRt;
async function getApmCorrelationValues({
  arguments: args,
  apmEventClient
}) {
  const getQueryForSet = set => {
    var _datemath$parse, _datemath$parse2;
    const start = (_datemath$parse = _datemath.default.parse(set.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
    const end = (_datemath$parse2 = _datemath.default.parse(set.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
    return {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _term_query.termQuery)(_apm.SERVICE_NAME, set['service.name']), ...(0, _server.kqlQuery)(set.filter)]
      }
    };
  };
  const allCorrelations = await Promise.all(args.sets.map(async set => {
    const query = getQueryForSet(set.foreground);
    let apm;
    let fields = [];
    switch (set.event) {
      case _constants.CorrelationsEventType.Transaction:
        apm = {
          events: [_common.ProcessorEvent.transaction]
        };
        fields = [_apm.TRANSACTION_NAME, _apm.SERVICE_NODE_NAME, _apm.TRANSACTION_RESULT];
        break;
      case _constants.CorrelationsEventType.ExitSpan:
        apm = {
          events: [_common.ProcessorEvent.span]
        };
        fields = [_apm.SPAN_NAME, _apm.SPAN_DESTINATION_SERVICE_RESOURCE];
        query.bool.filter.push({
          exists: {
            field: _apm.SPAN_DESTINATION_SERVICE_RESOURCE
          }
        });
        break;
      case _constants.CorrelationsEventType.Error:
        apm = {
          events: [_common.ProcessorEvent.error]
        };
        fields = ['error.grouping_name'];
        break;
    }
    const sigTermsAggs = {};
    fields.forEach(field => {
      sigTermsAggs[field] = {
        significant_terms: {
          field,
          background_filter: getQueryForSet(set.background),
          gnd: {
            background_is_superset: false
          }
        }
      };
    });
    const response = await apmEventClient.search('get_significant_terms', {
      apm,
      body: {
        size: 0,
        track_total_hits: false,
        query,
        aggs: sigTermsAggs
      }
    });
    const correlations = [];
    if (!response.aggregations) {
      return {
        correlations: []
      };
    }

    // eslint-disable-next-line guard-for-in
    for (const fieldName in response.aggregations) {
      correlations.push({
        foreground: set.foreground.label,
        background: set.background.label,
        fieldName,
        fields: response.aggregations[fieldName].buckets.map(bucket => ({
          score: bucket.score,
          value: String(bucket.key)
        }))
      });
    }
    return {
      correlations
    };
  }));
  return allCorrelations.flatMap(_ => _.correlations);
}