"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeIdContext = void 0;
exports.TimeRangeIdContextProvider = TimeRangeIdContextProvider;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeRangeIdContext = /*#__PURE__*/(0, _react.createContext)({
  incrementTimeRangeId: () => {},
  timeRangeId: 0
});
exports.TimeRangeIdContext = TimeRangeIdContext;
function TimeRangeIdContextProvider({
  children
}) {
  const [timeRangeId, setTimeRangeId] = (0, _react.useState)(0);
  const api = (0, _react.useMemo)(() => {
    return {
      incrementTimeRangeId: () => setTimeRangeId(id => id + 1),
      timeRangeId
    };
  }, [timeRangeId, setTimeRangeId]);
  return /*#__PURE__*/_react.default.createElement(TimeRangeIdContext.Provider, {
    value: api
  }, children);
}