"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _polished = require("polished");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _style = require("../../../../utils/style");
var _suggestion = _interopRequireDefault(require("./suggestion"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const List = _common.euiStyled.ul`
  width: 100%;
  border: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadiusSmall};
  box-shadow: 0 ${({
  theme
}) => `${theme.eui.euiSizeXS} ${theme.eui.euiSizeXL} ${(0, _polished.tint)(0.9, theme.eui.euiColorFullShade)}`};
  position: absolute;
  background: ${({
  theme
}) => theme.eui.euiColorEmptyShade};
  z-index: 10;
  left: 0;
  max-height: ${_style.unit * 20}px;
  overflow: scroll;
`;
class Suggestions extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "childNodes", []);
    (0, _defineProperty2.default)(this, "scrollIntoView", () => {
      const parent = this.parentNode;
      const child = this.childNodes[this.props.index];
      if (this.props.index == null || !parent || !child) {
        return;
      }
      const scrollTop = Math.max(Math.min(parent.scrollTop, child.offsetTop), child.offsetTop + child.offsetHeight - parent.offsetHeight);
      parent.scrollTop = scrollTop;
    });
  }
  componentDidUpdate(prevProps) {
    if (prevProps.index !== this.props.index) {
      this.scrollIntoView();
    }
  }
  render() {
    if (!this.props.show || (0, _lodash.isEmpty)(this.props.suggestions)) {
      return null;
    }
    const suggestions = this.props.suggestions.map((suggestion, index) => {
      const key = suggestion + '_' + index;
      return /*#__PURE__*/_react.default.createElement(_suggestion.default, {
        innerRef: node => this.childNodes[index] = node,
        selected: index === this.props.index,
        suggestion: suggestion,
        onClick: this.props.onClick,
        onMouseEnter: () => this.props.onMouseEnter(index),
        key: key
      });
    });
    return /*#__PURE__*/_react.default.createElement(List, {
      "data-test-subj": "suggestionContainer",
      innerRef: node => this.parentNode = node
    }, suggestions);
  }
}
Suggestions.propTypes = {
  index: _propTypes.default.number,
  onClick: _propTypes.default.func.isRequired,
  onMouseEnter: _propTypes.default.func.isRequired,
  show: _propTypes.default.bool,
  suggestions: _propTypes.default.array.isRequired
};
var _default = Suggestions;
exports.default = _default;
module.exports = exports.default;