"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dependencies = exports.DependenciesInventoryTitle = void 0;
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _queryString = _interopRequireDefault(require("query-string"));
var _page_template = require("./page_template");
var _comparison_rt = require("../../../../common/comparison_rt");
var _dependency_detail_operations = require("../../app/dependency_detail_operations");
var _dependency_detail_overview = require("../../app/dependency_detail_overview");
var _dependency_detail_view = require("../../app/dependency_detail_view");
var _dependencies_inventory = require("../../app/dependencies_inventory");
var _dependency_operation_detail_view = require("../../app/dependency_operation_detail_view");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _transaction_tabs = require("../../app/transaction_details/waterfall_with_summary/transaction_tabs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DependenciesInventoryTitle = _i18n.i18n.translate('xpack.apm.views.dependenciesInventory.title', {
  defaultMessage: 'Dependencies'
});
exports.DependenciesInventoryTitle = DependenciesInventoryTitle;
function RedirectDependenciesToDependenciesOverview() {
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/dependencies');
  const search = _queryString.default.stringify(query);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `/dependencies/overview`,
      search
    }
  });
}
const dependencies = {
  ...(0, _page_template.page)({
    path: '/dependencies/inventory',
    title: DependenciesInventoryTitle,
    element: /*#__PURE__*/_react.default.createElement(_dependencies_inventory.DependenciesInventory, null),
    params: t.partial({
      query: t.intersection([t.type({
        comparisonEnabled: _ioTsUtils.toBooleanRt
      }), _comparison_rt.offsetRt])
    })
  }),
  '/dependencies': {
    element: /*#__PURE__*/_react.default.createElement(_dependency_detail_view.DependencyDetailView, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
    params: t.partial({
      query: t.intersection([t.type({
        comparisonEnabled: _ioTsUtils.toBooleanRt,
        dependencyName: t.string
      }), _comparison_rt.offsetRt])
    }),
    children: {
      '/dependencies': {
        element: /*#__PURE__*/_react.default.createElement(RedirectDependenciesToDependenciesOverview, null)
      },
      '/dependencies/operations': {
        element: /*#__PURE__*/_react.default.createElement(_dependency_detail_operations.DependencyDetailOperations, null)
      },
      '/dependencies/operation': {
        params: t.type({
          query: t.intersection([t.type({
            spanName: t.string,
            detailTab: t.union([t.literal(_transaction_tabs.TransactionTab.timeline), t.literal(_transaction_tabs.TransactionTab.metadata), t.literal(_transaction_tabs.TransactionTab.logs)]),
            showCriticalPath: _ioTsUtils.toBooleanRt
          }), t.partial({
            spanId: t.string,
            sampleRangeFrom: _ioTsUtils.toNumberRt,
            sampleRangeTo: _ioTsUtils.toNumberRt,
            waterfallItemId: t.string,
            flyoutDetailTab: t.string
          })])
        }),
        defaults: {
          query: {
            detailTab: _transaction_tabs.TransactionTab.timeline,
            showCriticalPath: ''
          }
        },
        element: /*#__PURE__*/_react.default.createElement(_dependency_operation_detail_view.DependencyOperationDetailView, null)
      },
      '/dependencies/overview': {
        element: /*#__PURE__*/_react.default.createElement(_dependency_detail_overview.DependencyDetailOverview, null)
      }
    }
  }
};
exports.dependencies = dependencies;