"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TAIL_SAMPLING_ENABLED_KEY = void 0;
exports.getTailSamplingSettings = getTailSamplingSettings;
exports.isTailBasedSamplingValid = isTailBasedSamplingValid;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _utils = require("../settings_form/utils");
var _duration_rt = require("../../../../../common/agent_configuration/runtime_types/duration_rt");
var _storage_size_rt = require("../../../../../common/agent_configuration/runtime_types/storage_size_rt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAIL_SAMPLING_ENABLED_KEY = 'tail_sampling_enabled';
exports.TAIL_SAMPLING_ENABLED_KEY = TAIL_SAMPLING_ENABLED_KEY;
function getTailSamplingSettings(docsLinks) {
  return [{
    key: TAIL_SAMPLING_ENABLED_KEY,
    rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingEnabledTitle', {
      defaultMessage: 'Enable tail-based sampling'
    }),
    rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.enableTailSamplingDescription', {
      defaultMessage: 'Enable tail-based sampling.'
    }),
    type: 'boolean',
    settings: [{
      key: 'tail_sampling_interval',
      type: 'duration',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingInterval', {
        defaultMessage: 'Tail sampling interval'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingIntervalTitle', {
        defaultMessage: 'Interval'
      }),
      rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingIntervalDescription', {
        defaultMessage: 'Interval for synchronization between multiple APM Servers. Should be in the order of tens of seconds or low minutes.'
      }),
      labelAppend: _utils.OPTIONAL_LABEL,
      required: false,
      validation: (0, _duration_rt.getDurationRt)({
        min: '1s'
      })
    }, {
      key: 'tail_sampling_policies',
      type: 'yaml',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingPolicies', {
        defaultMessage: 'Tail sampling policies'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingPoliciesTitle', {
        defaultMessage: 'Policies'
      }),
      rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingPoliciesDescription', {
        defaultMessage: 'Policies map trace events to a sample rate. Each policy must specify a sample rate. Trace events are matched to policies in the order specified. All policy conditions must be true for a trace event to match. Each policy list should conclude with a policy that only specifies a sample rate. This final policy is used to catch remaining trace events that don’t match a stricter policy.'
      }),
      helpText: docsLinks && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.fleet_integration.settings.tailSamplingDocsHelpText",
        defaultMessage: "Learn more about tail sampling policies in our {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "apmGetTailSamplingSettingsDocsLink",
            href: docsLinks,
            target: "_blank"
          }, _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSamplingDocsHelpTextLink', {
            defaultMessage: 'docs'
          }))
        }
      }),
      required: true
    }, {
      key: 'tail_sampling_storage_limit',
      type: 'storageSize',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingStorageLimit', {
        defaultMessage: 'Tail sampling storage limit'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingStorageLimitTitle', {
        defaultMessage: 'Storage limit'
      }),
      rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingStorageLimitDescription', {
        defaultMessage: 'The amount of storage space allocated for trace events matching tail sampling policies. Caution: Setting this limit higher than the allowed space may cause APM Server to become unhealthy.'
      }),
      labelAppend: _utils.OPTIONAL_LABEL,
      required: false,
      validation: (0, _storage_size_rt.getStorageSizeRt)({
        min: '0GB'
      })
    }]
  }];
}
function isTailBasedSamplingValid(newVars, tailSamplingSettings) {
  // only validates TBS when its flag is enabled
  return !newVars[TAIL_SAMPLING_ENABLED_KEY].value || (0, _utils.isSettingsFormValid)(tailSamplingSettings, newVars);
}