"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingTransactionWarning = MissingTransactionWarning;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MissingTransactionWarning() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: _i18n.i18n.translate('xpack.apm.transactionDetails.agentMissingTransactionMessage', {
      defaultMessage: 'This trace contains spans from missing transactions. As a result these spans are not displayed in the timeline.'
    }),
    anchorClassName: "eui-fullWidth"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "warning",
    color: "hollow",
    "data-test-id": "apm-missing-transaction-badge"
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.agentMissingTransactionLabel', {
    defaultMessage: 'Incomplete trace'
  })));
}