"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.traceSamplesTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _distribution = require("./distribution");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceSamplesTab({
  selectSampleFromChartSelection,
  clearChartSelection,
  sampleRangeFrom,
  sampleRangeTo,
  traceSamplesFetchResult
}) {
  return /*#__PURE__*/_react.default.createElement(_distribution.TransactionDistribution, {
    onChartSelection: selectSampleFromChartSelection,
    onClearSelection: clearChartSelection,
    selection: sampleRangeFrom !== undefined && sampleRangeTo !== undefined ? [sampleRangeFrom, sampleRangeTo] : undefined,
    traceSamplesFetchResult: traceSamplesFetchResult
  });
}
const traceSamplesTab = {
  dataTestSubj: 'apmTraceSamplesTabButton',
  key: 'traceSamples',
  label: _i18n.i18n.translate('xpack.apm.transactionDetails.tabs.traceSamplesLabel', {
    defaultMessage: 'Trace samples'
  }),
  component: TraceSamplesTab
};
exports.traceSamplesTab = traceSamplesTab;