"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceExplorer = TraceExplorer;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _trace_explorer = require("../../../../common/trace_explorer");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_apm_route_path = require("../../../hooks/use_apm_route_path");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_trace_explorer_samples = require("../../../hooks/use_trace_explorer_samples");
var _apm_date_picker = require("../../shared/date_picker/apm_date_picker");
var _url_helpers = require("../../shared/links/url_helpers");
var _technical_preview_badge = require("../../shared/technical_preview_badge");
var _transaction_tabs = require("../transaction_details/waterfall_with_summary/transaction_tabs");
var _trace_search_box = require("./trace_search_box");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceExplorer({
  children
}) {
  const [searchQuery, setSearchQuery] = (0, _react.useState)({
    query: '',
    type: _trace_explorer.TraceSearchType.kql
  });
  const {
    query,
    query: {
      rangeFrom,
      rangeTo,
      environment,
      query: queryFromUrlParams,
      type: typeFromUrlParams
    }
  } = (0, _use_apm_params.useApmParams)('/traces/explorer');
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    setSearchQuery({
      query: queryFromUrlParams,
      type: typeFromUrlParams
    });
  }, [queryFromUrlParams, typeFromUrlParams]);
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const params = (0, _react.useMemo)(() => {
    return {
      query: {
        start,
        end,
        environment,
        query: queryFromUrlParams,
        type: typeFromUrlParams
      }
    };
  }, [start, end, environment, queryFromUrlParams, typeFromUrlParams]);
  const router = (0, _use_apm_router.useApmRouter)();
  const routePath = (0, _use_apm_route_path.useApmRoutePath)();
  return /*#__PURE__*/_react.default.createElement(_use_trace_explorer_samples.TraceExplorerSamplesFetcherContextProvider, {
    params: params
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_trace_search_box.TraceSearchBox, {
    query: searchQuery,
    error: false,
    loading: false,
    onQueryCommit: () => {
      (0, _url_helpers.push)(history, {
        query: {
          query: searchQuery.query,
          type: searchQuery.type
        }
      });
    },
    onQueryChange: nextQuery => {
      setSearchQuery(nextQuery);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_apm_date_picker.ApmDatePicker, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    href: router.link('/traces/explorer/waterfall', {
      query: {
        ...query,
        traceId: '',
        transactionId: '',
        waterfallItemId: '',
        detailTab: _transaction_tabs.TransactionTab.timeline
      }
    }),
    isSelected: routePath === '/traces/explorer/waterfall'
  }, _i18n.i18n.translate('xpack.apm.traceExplorer.waterfallTab', {
    defaultMessage: 'Waterfall'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    href: router.link('/traces/explorer/critical_path', {
      query
    }),
    isSelected: routePath === '/traces/explorer/critical_path'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.apm.traceExplorer.criticalPathTab', {
    defaultMessage: 'Aggregated critical path'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    icon: "beaker",
    size: "s",
    style: {
      verticalAlign: 'middle'
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children)));
}