"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteButton = DeleteButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _create_call_apm_api = require("../../../../../services/rest/create_call_apm_api");
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _use_theme = require("../../../../../hooks/use_theme");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DeleteButton({
  onDelete,
  customLinkId
}) {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const theme = (0, _use_theme.useTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmDeleteButtonDeleteButton",
    color: "danger",
    isLoading: isDeleting,
    iconSide: "right",
    onClick: async () => {
      setIsDeleting(true);
      await deleteConfig(customLinkId, toasts);
      setIsDeleting(false);
      onDelete();
    },
    style: {
      marginRight: theme.eui.euiSize
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.delete', {
    defaultMessage: 'Delete'
  }));
}
async function deleteConfig(customLinkId, toasts) {
  try {
    await (0, _create_call_apm_api.callApmApi)('DELETE /internal/apm/settings/custom_links/{id}', {
      signal: null,
      params: {
        path: {
          id: customLinkId
        }
      }
    });
    toasts.addSuccess({
      iconType: 'trash',
      title: _i18n.i18n.translate('xpack.apm.settings.customLink.delete.successed', {
        defaultMessage: 'Deleted custom link.'
      })
    });
  } catch (error) {
    toasts.addDanger({
      iconType: 'cross',
      title: _i18n.i18n.translate('xpack.apm.settings.customLink.delete.failed', {
        defaultMessage: 'Custom link could not be deleted'
      })
    });
  }
}