"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = ConfirmDeleteModal;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConfirmDeleteModal({
  agentKey,
  onCancel,
  onConfirm
}) {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const {
    id,
    name
  } = agentKey;
  const deleteAgentKey = async () => {
    try {
      await (0, _create_call_apm_api.callApmApi)('POST /internal/apm/api_key/invalidate', {
        signal: null,
        params: {
          body: {
            id
          }
        }
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.apm.settings.agentKeys.invalidate.succeeded', {
        defaultMessage: 'Deleted APM agent key "{name}"',
        values: {
          name
        }
      }));
    } catch (error) {
      toasts.addDanger(_i18n.i18n.translate('xpack.apm.settings.agentKeys.invalidate.failed', {
        defaultMessage: 'Error deleting APM agent key "{name}"',
        values: {
          name
        }
      }));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.apm.settings.agentKeys.deleteConfirmModal.title', {
      defaultMessage: 'Delete APM agent key "{name}"?',
      values: {
        name
      }
    }),
    onCancel: onCancel,
    onConfirm: async () => {
      setIsDeleting(true);
      await deleteAgentKey();
      setIsDeleting(false);
      onConfirm();
    },
    cancelButtonText: _i18n.i18n.translate('xpack.apm.settings.agentKeys.deleteConfirmModal.cancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.apm.settings.agentKeys.deleteConfirmModal.delete', {
      defaultMessage: 'Delete'
    }),
    confirmButtonDisabled: isDeleting,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  });
}