"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverview = ServiceOverview;
exports.chartHeight = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _agent_name = require("../../../../common/agent_name");
var _annotations_context = require("../../../context/annotations/annotations_context");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _chart_pointer_event_context = require("../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _use_time_range = require("../../../hooks/use_time_range");
var _aggregated_transactions_badge = require("../../shared/aggregated_transactions_badge");
var _failed_transaction_rate_chart = require("../../shared/charts/failed_transaction_rate_chart");
var _latency_chart = require("../../shared/charts/latency_chart");
var _transaction_breakdown_chart = require("../../shared/charts/transaction_breakdown_chart");
var _transaction_coldstart_rate_chart = require("../../shared/charts/transaction_coldstart_rate_chart");
var _transactions_table = require("../../shared/transactions_table");
var _service_overview_dependencies_table = require("./service_overview_dependencies_table");
var _service_overview_errors_table = require("./service_overview_errors_table");
var _service_overview_instances_chart_and_table = require("./service_overview_instances_chart_and_table");
var _service_overview_throughput_chart = require("./service_overview_throughput_chart");
var _slo_callout = require("../../shared/slo_callout");
var _use_local_storage = require("../../../hooks/use_local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The height a chart should be if it's next to a table with 5 rows and a title.
 * Add the height of the pagination row.
 */
const chartHeight = 288;
exports.chartHeight = chartHeight;
function ServiceOverview() {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    serviceName,
    fallbackToTransactions,
    agentName,
    serverlessType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query,
    query: {
      kuery,
      environment,
      rangeFrom,
      rangeTo,
      transactionType
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/overview');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const isRumAgent = (0, _agent_name.isRumAgentName)(agentName);
  const isOpenTelemetryAgent = (0, _agent_name.isOpenTelemetryAgentName)(agentName);
  const isServerless = (0, _agent_name.isServerlessAgentName)(serverlessType);
  const dependenciesLink = router.link('/services/{serviceName}/dependencies', {
    path: {
      serviceName
    },
    query
  });

  // The default EuiFlexGroup breaks at 768, but we want to break at 1200, so we
  // observe the window width and set the flex directions of rows accordingly
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const isSingleColumn = isLarge;
  const latencyChartHeight = 200;
  const nonLatencyChartHeight = isSingleColumn ? latencyChartHeight : chartHeight;
  const rowDirection = isSingleColumn ? 'column' : 'row';
  const [sloCalloutDismissed, setSloCalloutDismissed] = (0, _use_local_storage.useLocalStorage)('apm.sloCalloutDismissed', false);
  return /*#__PURE__*/_react.default.createElement(_annotations_context.AnnotationsContextProvider, {
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end
  }, !sloCalloutDismissed && /*#__PURE__*/_react.default.createElement(_slo_callout.SloCallout, {
    dismissCallout: () => {
      setSloCalloutDismissed(true);
    },
    serviceName: serviceName,
    environment: environment,
    transactionType: transactionType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, fallbackToTransactions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_aggregated_transactions_badge.AggregatedTransactionsBadge, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_latency_chart.LatencyChart, {
    height: latencyChartHeight,
    kuery: kuery
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_service_overview_throughput_chart.ServiceOverviewThroughputChart, {
    height: nonLatencyChartHeight,
    kuery: kuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_transactions_table.TransactionsTable, {
    kuery: kuery,
    environment: environment,
    fixedHeight: true,
    isSingleColumn: isSingleColumn,
    start: start,
    end: end,
    showPerPageOptions: false
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false
  }, !isRumAgent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_failed_transaction_rate_chart.FailedTransactionRateChart, {
    height: nonLatencyChartHeight,
    showAnnotations: false,
    kuery: kuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_service_overview_errors_table.ServiceOverviewErrorsTable, {
    serviceName: serviceName
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false
  }, isServerless ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_transaction_coldstart_rate_chart.TransactionColdstartRateChart, {
    showAnnotations: false,
    environment: environment,
    kuery: kuery
  })) : !isOpenTelemetryAgent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_transaction_breakdown_chart.TransactionBreakdownChart, {
    showAnnotations: false,
    environment: environment,
    kuery: kuery
  })), !isRumAgent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_service_overview_dependencies_table.ServiceOverviewDependenciesTable, {
    fixedHeight: true,
    showPerPageOptions: false,
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "apmServiceOverviewViewDependenciesLink",
      href: dependenciesLink
    }, _i18n.i18n.translate('xpack.apm.serviceOverview.dependenciesTableTabLink', {
      defaultMessage: 'View dependencies'
    }))
  }))))), !isRumAgent && !isServerless && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_service_overview_instances_chart_and_table.ServiceOverviewInstancesChartAndTable, {
    chartHeight: nonLatencyChartHeight,
    serviceName: serviceName
  }))))));
}