"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GotoDashboard = GotoDashboard;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GotoDashboard({
  currentDashboard
}) {
  const {
    services: {
      dashboard: {
        locator: dashboardLocator
      }
    }
  } = (0, _public.useKibana)();
  const url = dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
    dashboardId: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.dashboardSavedObjectId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmGotoDashboardGoToDashboardButton",
    color: "text",
    size: "s",
    iconType: 'visGauge',
    href: url
  }, _i18n.i18n.translate('xpack.apm.serviceDashboards.contextMenu.goToDashboard', {
    defaultMessage: 'Go to dashboard'
  }));
}