"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingOverview = ProfilingOverview;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _document_type = require("../../../../common/document_type");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _use_preferred_data_source_and_bucket_size = require("../../../hooks/use_preferred_data_source_and_bucket_size");
var _use_profiling_plugin = require("../../../hooks/use_profiling_plugin");
var _use_time_range = require("../../../hooks/use_time_range");
var _url_helpers = require("../../shared/links/url_helpers");
var _profiling_flamegraph = require("./profiling_flamegraph");
var _profiling_top_functions = require("./profiling_top_functions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ProfilingOverview() {
  var _services$docLinks;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    path: {
      serviceName
    },
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/profiling');
  const {
    isProfilingAvailable,
    isLoading
  } = (0, _use_profiling_plugin.useProfilingPlugin)();
  const {
    start,
    end,
    refreshTimeRange
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery,
    type: _document_type.ApmDocumentType.TransactionMetric,
    numBuckets: 20
  });
  const [apmUniversalProfilingShowCallout, setAPMUniversalProfilingShowCallout] = (0, _use_local_storage.useLocalStorage)('apmUniversalProfilingShowCallout', true);
  const baseUrl = ((_services$docLinks = services.docLinks) === null || _services$docLinks === void 0 ? void 0 : _services$docLinks.ELASTIC_WEBSITE_URL) || 'https://www.elastic.co/';
  const tabs = (0, _react2.useMemo)(() => {
    return [{
      id: 'flamegraph',
      name: _i18n.i18n.translate('xpack.apm.profiling.tabs.flamegraph', {
        defaultMessage: 'Flamegraph'
      }),
      content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react2.default.createElement(_profiling_flamegraph.ProfilingFlamegraph, {
        serviceName: serviceName,
        start: start,
        end: end,
        environment: environment,
        dataSource: preferred === null || preferred === void 0 ? void 0 : preferred.source,
        kuery: kuery,
        rangeFrom: rangeFrom,
        rangeTo: rangeTo
      }))
    }, {
      id: 'topNFunctions',
      name: _i18n.i18n.translate('xpack.apm.profiling.tabs.topNFunctions', {
        defaultMessage: 'Top 10 Functions'
      }),
      content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react2.default.createElement(_profiling_top_functions.ProfilingTopNFunctions, {
        serviceName: serviceName,
        start: start,
        end: end,
        environment: environment,
        startIndex: 0,
        endIndex: 10,
        dataSource: preferred === null || preferred === void 0 ? void 0 : preferred.source,
        kuery: kuery,
        rangeFrom: rangeFrom,
        rangeTo: rangeTo
      }))
    }];
  }, [end, environment, kuery, preferred === null || preferred === void 0 ? void 0 : preferred.source, rangeFrom, rangeTo, serviceName, start]);
  if (isLoading) {
    return /*#__PURE__*/_react2.default.createElement("div", {
      css: (0, _react.css)`
          display: flex;
          justify-content: center;
        `
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    }));
  }
  if (isProfilingAvailable === false) {
    return /*#__PURE__*/_react2.default.createElement(_public2.ProfilingEmptyState, null);
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, apmUniversalProfilingShowCallout && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.profiling.callout.title', {
      defaultMessage: 'Displaying profiling insights from the host(s) running {serviceName} services',
      values: {
        serviceName
      }
    }),
    color: "primary",
    iconType: "iInCircle"
  }, /*#__PURE__*/_react2.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.profiling.callout.description', {
    defaultMessage: 'Universal Profiling provides unprecedented code visibility into the runtime behaviour of all applications. It profiles every line of code on the host(s) running your services, including not only your application code but also the kernel and third-party libraries.'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: `${baseUrl}observability/universal-profiling`,
    target: "_blank",
    "data-test-subj": "apmProfilingOverviewLearnMoreLink"
  }, _i18n.i18n.translate('xpack.apm.profiling.callout.learnMore', {
    defaultMessage: 'Learn more'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmProfilingOverviewLinkButtonButton",
    color: "primary",
    onClick: () => {
      setAPMUniversalProfilingShowCallout(false);
    }
  }, _i18n.i18n.translate('xpack.apm.profiling.callout.dismiss', {
    defaultMessage: 'Dismiss'
  }))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react2.default.createElement(_public2.EmbeddableProfilingSearchBar, {
    kuery: kuery,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    onQuerySubmit: next => {
      (0, _url_helpers.push)(history, {
        query: {
          kuery: next.query,
          rangeFrom: next.dateRange.from,
          rangeTo: next.dateRange.to
        }
      });
    },
    onRefresh: refreshTimeRange
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react2.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected"
  }));
}