"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileCrashGroupList = MobileCrashGroupList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _i18n2 = require("../../../../../../common/i18n");
var _formatters = require("../../../../../../common/utils/formatters");
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _style = require("../../../../../utils/style");
var _get_timeseries_color = require("../../../../shared/charts/helper/get_timeseries_color");
var _spark_plot = require("../../../../shared/charts/spark_plot");
var _crash_detail_link = require("../../../../shared/links/apm/mobile/crash_detail_link");
var _error_overview_link = require("../../../../shared/links/apm/mobile/error_overview_link");
var _managed_table = require("../../../../shared/managed_table");
var _timestamp_tooltip = require("../../../../shared/timestamp_tooltip");
var _get_comparison_options = require("../../../../shared/time_comparison/get_comparison_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MessageAndCulpritCell = _common.euiStyled.div`
  ${(0, _style.truncate)('100%')};
`;
const ErrorLink = (0, _common.euiStyled)(_error_overview_link.ErrorOverviewLink)`
  ${(0, _style.truncate)('100%')};
`;
function MobileCrashGroupList({
  mainStatistics,
  serviceName,
  detailedStatisticsLoading,
  detailedStatistics,
  comparisonEnabled,
  initialSortField,
  initialSortDirection,
  isLoading
}) {
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/errors-and-crashes');
  const {
    offset
  } = query;
  const columns = (0, _react.useMemo)(() => {
    return [{
      name: _i18n.i18n.translate('xpack.apm.errorsTable.typeColumnLabel', {
        defaultMessage: 'Type'
      }),
      field: 'type',
      sortable: false,
      render: (_, {
        type
      }) => {
        return /*#__PURE__*/_react.default.createElement(ErrorLink, {
          title: type,
          serviceName: serviceName,
          query: {
            ...query,
            kuery: `error.exception.type:"${type}"`
          }
        }, type);
      }
    }, {
      name: _i18n.i18n.translate('xpack.apm.crashTable.crashMessageAndCulpritColumnLabel', {
        defaultMessage: 'Crash message'
      }),
      field: 'message',
      sortable: false,
      width: '30%',
      render: (_, item) => {
        return /*#__PURE__*/_react.default.createElement(MessageAndCulpritCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          id: "error-message-tooltip",
          content: item.name || _i18n2.NOT_AVAILABLE_LABEL
        }, /*#__PURE__*/_react.default.createElement(_crash_detail_link.CrashDetailLink, {
          serviceName: serviceName,
          groupId: item.groupId,
          query: query
        }, item.name || _i18n2.NOT_AVAILABLE_LABEL)));
      }
    }, {
      field: 'lastSeen',
      sortable: true,
      name: _i18n.i18n.translate('xpack.apm.errorsTable.lastSeenColumnLabel', {
        defaultMessage: 'Last seen'
      }),
      align: _eui.LEFT_ALIGNMENT,
      render: (_, {
        lastSeen
      }) => lastSeen ? /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
        time: lastSeen,
        timeUnit: "minutes"
      }) : _i18n2.NOT_AVAILABLE_LABEL
    }, {
      field: 'occurrences',
      name: _i18n.i18n.translate('xpack.apm.errorsTable.occurrencesColumnLabel', {
        defaultMessage: 'Occurrences'
      }),
      sortable: true,
      dataType: 'number',
      align: _eui.RIGHT_ALIGNMENT,
      render: (_, {
        occurrences,
        groupId
      }) => {
        var _detailedStatistics$c, _detailedStatistics$c2, _detailedStatistics$p, _detailedStatistics$p2;
        const currentPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$c = detailedStatistics.currentPeriod) === null || _detailedStatistics$c === void 0 ? void 0 : (_detailedStatistics$c2 = _detailedStatistics$c[groupId]) === null || _detailedStatistics$c2 === void 0 ? void 0 : _detailedStatistics$c2.timeseries;
        const previousPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$p = detailedStatistics.previousPeriod) === null || _detailedStatistics$p === void 0 ? void 0 : (_detailedStatistics$p2 = _detailedStatistics$p[groupId]) === null || _detailedStatistics$p2 === void 0 ? void 0 : _detailedStatistics$p2.timeseries;
        const {
          currentPeriodColor,
          previousPeriodColor
        } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE);
        return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
          type: "bar",
          color: currentPeriodColor,
          isLoading: detailedStatisticsLoading,
          series: currentPeriodTimeseries,
          valueLabel: _i18n.i18n.translate('xpack.apm.serviceOverview.errorsTableOccurrences', {
            defaultMessage: `{occurrences} occ.`,
            values: {
              occurrences: (0, _formatters.asInteger)(occurrences)
            }
          }),
          comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimeseries : undefined,
          comparisonSeriesColor: previousPeriodColor
        });
      }
    }];
  }, [serviceName, query, detailedStatistics, comparisonEnabled, detailedStatisticsLoading, offset]);
  return /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    noItemsMessage: isLoading ? _i18n.i18n.translate('xpack.apm.errorsTable.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.crashTable.noCrashesLabel', {
      defaultMessage: 'No crashes found'
    }),
    items: mainStatistics,
    columns: columns,
    initialSortField: initialSortField,
    initialSortDirection: initialSortDirection,
    sortItems: false,
    initialPageSize: 25,
    isLoading: isLoading
  });
}