"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreemapSelect = TreemapSelect;
exports.TreemapTypes = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TreemapTypes;
exports.TreemapTypes = TreemapTypes;
(function (TreemapTypes) {
  TreemapTypes["OsVersions"] = "osVersions";
  TreemapTypes["AppVersions"] = "appVersions";
  TreemapTypes["Devices"] = "devices";
})(TreemapTypes || (exports.TreemapTypes = TreemapTypes = {}));
const options = [{
  value: TreemapTypes.Devices,
  label: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.devices', {
    defaultMessage: 'Devices'
  }),
  description: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.devices.subtitle', {
    defaultMessage: 'Treemap displaying the most affected devices.'
  })
}, {
  value: TreemapTypes.AppVersions,
  label: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.versions.devices', {
    defaultMessage: 'App versions'
  }),
  description: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.versions.subtitle', {
    defaultMessage: 'Treemap displaying the most affected application versions.'
  })
}, {
  value: TreemapTypes.OsVersions,
  label: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.osVersions', {
    defaultMessage: 'OS versions'
  }),
  description: _i18n.i18n.translate('xpack.apm.mobile.errorOverview.treemap.dropdown.osVersions.subtitle', {
    defaultMessage: 'Treemap displaying the most affected OS versions.'
  })
}].map(({
  value,
  label,
  description
}) => ({
  inputDisplay: label,
  value,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, description)))
}));
function TreemapSelect({
  selectedTreemap,
  onChange
}) {
  var _options$find;
  const currentTreemap = (_options$find = options.find(({
    value
  }) => value === selectedTreemap)) !== null && _options$find !== void 0 ? _options$find : options[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.errorsOverview.treemap.title', {
    defaultMessage: 'Most affected {currentTreemap}',
    values: {
      currentTreemap: currentTreemap.value
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    style: {
      minWidth: '150px'
    },
    options: options,
    valueOfSelected: selectedTreemap,
    onChange: onChange,
    itemLayoutAlign: "top",
    hasDividers: true
  }))));
}