"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonMetricsDashboard = JsonMetricsDashboard;
exports.getFilters = getFilters;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/dashboard-plugin/public");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _public3 = require("@kbn/controls-plugin/public");
var _common = require("@kbn/controls-plugin/common");
var _use_data_view_id = require("../../../../hooks/use_data_view_id");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_data_view = require("../../../../hooks/use_apm_data_view");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _helper = require("./helper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function JsonMetricsDashboard(dashboardProps) {
  const [dashboard, setDashboard] = (0, _react.useState)();
  const dataViewId = (0, _use_data_view_id.useDataViewId)();
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics');
  const {
    core: {
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    dataView
  } = (0, _use_apm_data_view.useApmDataView)();
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  (0, _react.useEffect)(() => {
    if (!dashboard) return;
    dashboard.updateInput({
      timeRange: {
        from: rangeFrom,
        to: rangeTo
      },
      query: {
        query: kuery,
        language: 'kuery'
      }
    });
  }, [kuery, dashboard, rangeFrom, rangeTo]);
  (0, _react.useEffect)(() => {
    if (!dashboard || !dataView) return;
    dashboard.updateInput({
      filters: dataView ? getFilters(serviceName, environment, dataView) : []
    });
  }, [dataView, serviceName, environment, dashboard]);
  if (!dataViewId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_public2.DashboardRenderer, {
    getCreationOptions: () => getCreationOptions(dashboardProps, notifications, dataViewId),
    ref: setDashboard
  });
}
async function getCreationOptions(dashboardProps, notifications, dataViewId) {
  try {
    const builder = _public3.controlGroupInputBuilder;
    const controlGroupInput = (0, _common.getDefaultControlGroupInput)();
    await builder.addDataControlFromField(controlGroupInput, {
      dataViewId,
      title: 'Node name',
      fieldName: 'service.node.name',
      width: 'medium',
      grow: true
    });
    const panels = await (0, _helper.getDashboardPanelMap)(dashboardProps, dataViewId);
    if (!panels) {
      throw new Error('Failed parsing dashboard panels.');
    }
    return {
      useControlGroupIntegration: true,
      getInitialInput: () => ({
        viewMode: _public.ViewMode.VIEW,
        panels,
        controlGroupInput
      })
    };
  } catch (error) {
    notifications.toasts.addDanger(getLoadFailureToastLabels(dashboardProps, error));
    return {};
  }
}
function getFilters(serviceName, environment, dataView) {
  const filters = [];
  const serviceNameField = dataView.getFieldByName('service.name');
  if (serviceNameField) {
    const serviceNameFilter = (0, _esQuery.buildPhraseFilter)(serviceNameField, serviceName, dataView);
    filters.push(serviceNameFilter);
  }
  const environmentField = dataView.getFieldByName('service.environment');
  if (environmentField && environment && environment !== _environment_filter_values.ENVIRONMENT_ALL.value) {
    if (environment === _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value) {
      const envExistsFilter = (0, _esQuery.buildExistsFilter)(environmentField, dataView);
      envExistsFilter.meta.negate = true;
      filters.push(envExistsFilter);
    } else {
      const environmentFilter = (0, _esQuery.buildPhraseFilter)(environmentField, environment, dataView);
      filters.push(environmentFilter);
    }
  }
  return filters;
}
function getLoadFailureToastLabels(props, error) {
  var _props$agentName, _props$runtimeName;
  return {
    title: _i18n.i18n.translate('xpack.apm.runtimeMetricsJsonDashboards.loadFailure.toast.title', {
      defaultMessage: 'Error while loading dashboard for agent "{agentName}" on runtime "{runtimeName}".',
      values: {
        agentName: (_props$agentName = props.agentName) !== null && _props$agentName !== void 0 ? _props$agentName : 'unknown',
        runtimeName: (_props$runtimeName = props.runtimeName) !== null && _props$runtimeName !== void 0 ? _props$runtimeName : 'unknown'
      }
    }),
    text: error.message
  };
}