"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraTab = void 0;
exports.useTabs = useTabs;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _apm = require("../../../../../common/es_fields/apm");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let InfraTab;
exports.InfraTab = InfraTab;
(function (InfraTab) {
  InfraTab["containers"] = "containers";
  InfraTab["pods"] = "pods";
  InfraTab["hosts"] = "hosts";
})(InfraTab || (exports.InfraTab = InfraTab = {}));
function useTabs({
  containerIds,
  podNames,
  hostNames,
  start,
  end
}) {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    metricsDataAccess
  } = services;
  const HostMetricsTable = metricsDataAccess === null || metricsDataAccess === void 0 ? void 0 : metricsDataAccess.HostMetricsTable;
  const ContainerMetricsTable = metricsDataAccess === null || metricsDataAccess === void 0 ? void 0 : metricsDataAccess.ContainerMetricsTable;
  const PodMetricsTable = metricsDataAccess === null || metricsDataAccess === void 0 ? void 0 : metricsDataAccess.PodMetricsTable;
  const timerange = (0, _react.useMemo)(() => ({
    from: start,
    to: end
  }), [start, end]);
  const hostsFilter = (0, _react.useMemo)(() => ({
    bool: {
      should: [{
        terms: {
          [_apm.HOST_NAME]: hostNames
        }
      }],
      minimum_should_match: 1
    }
  }), [hostNames]);
  const podsFilter = (0, _react.useMemo)(() => ({
    bool: {
      filter: [{
        terms: {
          [_apm.KUBERNETES_POD_NAME]: podNames
        }
      }]
    }
  }), [podNames]);
  const containersFilter = (0, _react.useMemo)(() => ({
    bool: {
      filter: [{
        terms: {
          [_apm.CONTAINER_ID]: containerIds
        }
      }]
    }
  }), [containerIds]);
  const containerMetricsTable = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), ContainerMetricsTable && ContainerMetricsTable({
    timerange,
    filterClauseDsl: containersFilter
  }));
  const podMetricsTable = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), PodMetricsTable && PodMetricsTable({
    timerange,
    filterClauseDsl: podsFilter
  }));
  const hostMetricsTable = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), HostMetricsTable && HostMetricsTable({
    timerange,
    filterClauseDsl: hostsFilter
  }));
  const tabs = [{
    id: InfraTab.containers,
    name: _i18n.i18n.translate('xpack.apm.views.infra.tabs.containers', {
      defaultMessage: 'Containers'
    }),
    content: containerMetricsTable,
    hidden: containerIds && containerIds.length <= 0
  }, {
    id: InfraTab.pods,
    name: _i18n.i18n.translate('xpack.apm.views.infra.tabs.pods', {
      defaultMessage: 'Pods'
    }),
    content: podMetricsTable,
    hidden: podNames && podNames.length <= 0
  }, {
    id: InfraTab.hosts,
    name: _i18n.i18n.translate('xpack.apm.views.infra.tabs.hosts', {
      defaultMessage: 'Hosts'
    }),
    content: hostMetricsTable
  }];
  return tabs.filter(t => !t.hidden).map(({
    id,
    name,
    content
  }) => ({
    id,
    name,
    content
  }));
}