"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaintextStacktrace = PlaintextStacktrace;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _exception_stacktrace_title = require("./exception_stacktrace_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PlaintextStacktrace({
  codeLanguage,
  message,
  stacktrace,
  type
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_exception_stacktrace_title.ExceptionStacktraceTitle, {
    type: type,
    message: message,
    codeLanguage: codeLanguage
  }), stacktrace && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    language: codeLanguage
  }, stacktrace));
}