"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@kbn/config-schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const configSchema = _configSchema.schema.object({
  indices: _configSchema.schema.object({
    transaction: _configSchema.schema.string({
      defaultValue: 'traces-apm*,apm-*'
    }),
    // TODO: remove apm-* pattern in 9.0
    span: _configSchema.schema.string({
      defaultValue: 'traces-apm*,apm-*'
    }),
    error: _configSchema.schema.string({
      defaultValue: 'logs-apm*,apm-*'
    }),
    metric: _configSchema.schema.string({
      defaultValue: 'metrics-apm*,apm-*'
    }),
    onboarding: _configSchema.schema.string({
      defaultValue: 'apm-*'
    }),
    // Unused: to be deleted
    sourcemap: _configSchema.schema.string({
      defaultValue: 'apm-*'
    }) // Unused: to be deleted
  })
});

// plugin config
const config = {
  deprecations: ({
    renameFromRoot,
    unused,
    deprecate
  }) => [
  // deprecations
  deprecate('indices.sourcemap', 'a future version', {
    level: 'warning',
    message: `Configuring "xpack.apm.indices.sourcemap" is deprecated and will be removed in a future version. Please remove this setting.`
  }), deprecate('indices.onboarding', 'a future version', {
    level: 'warning',
    message: `Configuring "xpack.apm.indices.onboarding" is deprecated and will be removed in a future version. Please remove this setting.`
  }),
  // deprecations due to removal of apm_oss plugin
  renameFromRoot('apm_oss.transactionIndices', 'xpack.apm.indices.transaction', {
    level: 'warning'
  }), renameFromRoot('apm_oss.spanIndices', 'xpack.apm.indices.span', {
    level: 'warning'
  }), renameFromRoot('apm_oss.errorIndices', 'xpack.apm.indices.error', {
    level: 'warning'
  }), renameFromRoot('apm_oss.metricsIndices', 'xpack.apm.indices.metric', {
    level: 'warning'
  }), renameFromRoot('apm_oss.onboardingIndices', 'xpack.apm.indices.onboarding', {
    level: 'warning'
  }),
  // rename from apm to apm_data_access plugin
  renameFromRoot('xpack.apm.indices.transaction', 'xpack.apm_data_access.indices.transaction', {
    level: 'warning',
    silent: true
  }), renameFromRoot('xpack.apm.indices.span', 'xpack.apm_data_access.indices.span', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.indices.error', 'xpack.apm_data_access.indices.error', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.indices.metric', 'xpack.apm_data_access.indices.metric', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.indices.sourcemap', 'xpack.apm_data_access.indices.sourcemap', {
    level: 'warning'
  }), renameFromRoot('xpack.apm.indices.onboarding', 'xpack.apm_data_access.indices.onboarding', {
    level: 'warning'
  })],
  schema: configSchema
};
exports.config = config;
async function plugin(initializerContext) {
  const {
    ApmDataAccessPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new ApmDataAccessPlugin(initializerContext);
}