"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unmuteInstance = unmuteInstance;
var _authorization = require("../../authorization");
var _retry_if_conflicts = require("../../lib/retry_if_conflicts");
var _audit_events = require("../common/audit_events");
var _lib = require("../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function unmuteInstance(context, {
  alertId,
  alertInstanceId
}) {
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `rulesClient.unmuteInstance('${alertId}')`, async () => await unmuteInstanceWithOCC(context, {
    alertId,
    alertInstanceId
  }));
}
async function unmuteInstanceWithOCC(context, {
  alertId,
  alertInstanceId
}) {
  var _context$auditLogger2;
  const {
    attributes,
    version
  } = await context.unsecuredSavedObjectsClient.get('alert', alertId);
  try {
    await context.authorization.ensureAuthorized({
      ruleTypeId: attributes.alertTypeId,
      consumer: attributes.consumer,
      operation: _authorization.WriteOperations.UnmuteAlert,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
    if (attributes.actions.length) {
      await context.actionsAuthorization.ensureAuthorized({
        operation: 'execute'
      });
    }
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.UNMUTE_ALERT,
      savedObject: {
        type: 'alert',
        id: alertId
      },
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.UNMUTE_ALERT,
    outcome: 'unknown',
    savedObject: {
      type: 'alert',
      id: alertId
    }
  }));
  context.ruleTypeRegistry.ensureRuleTypeEnabled(attributes.alertTypeId);
  const mutedInstanceIds = attributes.mutedInstanceIds || [];
  if (!attributes.muteAll && mutedInstanceIds.includes(alertInstanceId)) {
    await context.unsecuredSavedObjectsClient.update('alert', alertId, (0, _lib.updateMeta)(context, {
      updatedBy: await context.getUserName(),
      updatedAt: new Date().toISOString(),
      mutedInstanceIds: mutedInstanceIds.filter(id => id !== alertInstanceId)
    }), {
      version
    });
  }
}