"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleTagsRoute = void 0;
var _transforms = require("./transforms");
var _tags = require("../../../../../common/routes/rule/apis/tags");
var _types = require("../../../../types");
var _lib = require("../../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleTagsRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/_tags`,
    validate: {
      query: _tags.ruleTagsRequestQuerySchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const query = req.query;
    const options = (0, _transforms.transformRuleTagsQueryRequestV1)(query);
    const tagsResult = await rulesClient.getTags(options);
    return res.ok({
      body: (0, _transforms.transformRuleTagsBodyResponseV1)(tagsResult)
    });
  })));
};
exports.getRuleTagsRoute = getRuleTagsRoute;