"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rRuleSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _validate_rrule_by = require("../../lib/validate_rrule_by");
var _validate_snooze_date = require("../../lib/validate_snooze_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rRuleSchema = _configSchema.schema.object({
  dtstart: _configSchema.schema.string({
    validate: _validate_snooze_date.validateSnoozeStartDate
  }),
  tzid: _configSchema.schema.string(),
  freq: _configSchema.schema.maybe(_configSchema.schema.number({
    validate: freq => {
      if (freq < 0 || freq > 3) return 'rRule freq must be 0, 1, 2, or 3';
    }
  })),
  interval: _configSchema.schema.maybe(_configSchema.schema.number({
    validate: interval => {
      if (interval < 1) return 'rRule interval must be > 0';
    }
  })),
  until: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: _validate_snooze_date.validateSnoozeEndDate
  })),
  count: _configSchema.schema.maybe(_configSchema.schema.number({
    validate: count => {
      if (count < 1) return 'rRule count must be > 0';
    }
  })),
  byweekday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    validate: (0, _validate_rrule_by.createValidateRruleBy)('byweekday')
  })),
  bymonthday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number(), {
    validate: (0, _validate_rrule_by.createValidateRruleBy)('bymonthday')
  })),
  bymonth: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number(), {
    validate: (0, _validate_rrule_by.createValidateRruleBy)('bymonth')
  }))
});
exports.rRuleSchema = rRuleSchema;