"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowCategorySelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _coreApplicationCommon = require("@kbn/core-application-common");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHECKBOX_OPTIONS = [{
  id: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.observability.id,
  label: i18n.CREATE_FORM_CATEGORY_OBSERVABILITY_RULES,
  ['data-test-subj']: `option-${_coreApplicationCommon.DEFAULT_APP_CATEGORIES.observability.id}`
}, {
  id: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
  label: i18n.CREATE_FORM_CATEGORY_SECURITY_RULES,
  ['data-test-subj']: `option-${_coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id}`
}, {
  id: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.management.id,
  label: i18n.CREATE_FORM_CATEGORY_STACK_RULES,
  ['data-test-subj']: `option-${_coreApplicationCommon.DEFAULT_APP_CATEGORIES.management.id}`
}].sort((a, b) => a.id.localeCompare(b.id));
const MaintenanceWindowCategorySelection = props => {
  const {
    selectedCategories,
    availableCategories,
    errors = [],
    isLoading = false,
    isScopedQueryEnabled = false,
    onChange
  } = props;
  const selectedMap = (0, _react.useMemo)(() => {
    return selectedCategories.reduce((result, category) => {
      result[category] = true;
      return result;
    }, {});
  }, [selectedCategories]);
  const options = (0, _react.useMemo)(() => {
    return CHECKBOX_OPTIONS.map(option => ({
      ...option,
      disabled: !availableCategories.includes(option.id)
    })).sort((a, b) => a.id.localeCompare(b.id));
  }, [availableCategories]);
  const onCheckboxChange = (0, _react.useCallback)(id => {
    if (selectedCategories.includes(id)) {
      onChange(selectedCategories.filter(category => category !== id));
    } else {
      onChange([...selectedCategories, id]);
    }
  }, [selectedCategories, onChange]);
  const onRadioChange = (0, _react.useCallback)(id => {
    onChange([id]);
  }, [onChange]);
  const categorySelection = (0, _react.useMemo)(() => {
    if (isScopedQueryEnabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
        "data-test-subj": "maintenanceWindowCategorySelectionRadioGroup",
        options: options,
        idSelected: selectedCategories[0],
        onChange: onRadioChange
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
      "data-test-subj": "maintenanceWindowCategorySelectionCheckboxGroup",
      options: options,
      idToSelectedMap: selectedMap,
      onChange: onCheckboxChange
    });
  }, [isScopedQueryEnabled, options, selectedCategories, selectedMap, onCheckboxChange, onRadioChange]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      "data-test-subj": "maintenanceWindowCategorySelectionLoading"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "maintenanceWindowCategorySelection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.CREATE_FORM_CATEGORY_SELECTION_TITLE), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, i18n.CREATE_FORM_CATEGORY_SELECTION_DESCRIPTION)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.CREATE_FORM_CATEGORIES_SELECTION_CHECKBOX_GROUP_TITLE,
    isInvalid: !!errors.length,
    error: errors[0]
  }, categorySelection)));
};
exports.MaintenanceWindowCategorySelection = MaintenanceWindowCategorySelection;