"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyTitle = /*#__PURE__*/_react.default.createElement("h2", null, i18n.EMPTY_PROMPT_TITLE);
const emptyBody = /*#__PURE__*/_react.default.createElement("p", null, i18n.EMPTY_PROMPT_DESCRIPTION);
const EmptyPrompt = /*#__PURE__*/_react.default.memo(({
  onClickCreate,
  showCreateButton = true,
  docLinks
}) => {
  const renderActions = (0, _react.useMemo)(() => {
    if (showCreateButton) {
      return [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "create-action",
        fill: true,
        onClick: onClickCreate
      }, i18n.EMPTY_PROMPT_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        key: "documentation-button",
        target: "_blank",
        href: docLinks.alerting.maintenanceWindows,
        iconType: "help"
      }, i18n.EMPTY_PROMPT_DOCUMENTATION)];
    }
    return null;
  }, [showCreateButton, onClickCreate, docLinks]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    "data-test-subj": "mw-empty-prompt",
    title: emptyTitle,
    body: emptyBody,
    actions: renderActions
  });
});
exports.EmptyPrompt = EmptyPrompt;
EmptyPrompt.displayName = 'EmptyPrompt';