"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchTopCategories = void 0;
var _lodash = require("lodash");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _fetch_categories = require("./fetch_categories");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchTopCategories = async (esClient, params, fieldNames, logger,
// The default value of 1 means no sampling will be used
sampleProbability = 1, emitError, abortSignal) => {
  const categoriesOverall = await (0, _fetch_categories.fetchCategories)(esClient, params, fieldNames, logger, sampleProbability, emitError, abortSignal);
  if (categoriesOverall.length !== fieldNames.length) return [];
  const topCategories = [];

  // Using for...of to allow `await` within the loop.
  for (const [i, fieldName] of fieldNames.entries()) {
    if (categoriesOverall[i].categories.length === 0) {
      continue;
    }

    // Get all unique keys
    const allKeys = (0, _lodash.uniq)(categoriesOverall[i].categories.map(cd => cd.key));
    allKeys.forEach(key => {
      var _categoryData$example, _categoryData$count;
      const categoryData = categoriesOverall[i].categories.find(c => c.key === key);
      topCategories.push({
        key,
        fieldName,
        fieldValue: (_categoryData$example = categoryData === null || categoryData === void 0 ? void 0 : categoryData.examples[0]) !== null && _categoryData$example !== void 0 ? _categoryData$example : '',
        doc_count: (_categoryData$count = categoryData === null || categoryData === void 0 ? void 0 : categoryData.count) !== null && _categoryData$count !== void 0 ? _categoryData$count : 0,
        bg_count: 0,
        total_doc_count: 0,
        total_bg_count: 0,
        score: 0,
        pValue: 1,
        normalizedScore: 0,
        type: _mlAggUtils.SIGNIFICANT_ITEM_TYPE.LOG_PATTERN
      });
    });
  }
  return topCategories;
};
exports.fetchTopCategories = fetchTopCategories;