"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routeHandlerFactory = void 0;
var _mlCategoryValidator = require("@kbn/ml-category-validator");
var _error_wrapper = require("../error_wrapper");
var _track_route_usage = require("../../lib/track_route_usage");
var _constants = require("../../../common/constants");
var _api = require("../../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routeHandlerFactory = (license, usageCounter) => async (context, request, response) => {
  const {
    headers
  } = request;
  (0, _track_route_usage.trackAIOpsRouteUsage)(`POST ${_api.AIOPS_API_ENDPOINT.CATEGORIZATION_FIELD_VALIDATION}`, headers[_constants.AIOPS_TELEMETRY_ID.AIOPS_ANALYSIS_RUN_ORIGIN], usageCounter);
  if (!license.isActivePlatinumLicense) {
    return response.forbidden();
  }
  try {
    const {
      elasticsearch: {
        client
      }
    } = await context.core;
    const {
      indexPatternTitle,
      timeField,
      query,
      size,
      field,
      start,
      end,
      analyzer,
      runtimeMappings,
      indicesOptions,
      includeExamples
    } = request.body;
    const {
      validateCategoryExamples
    } = (0, _mlCategoryValidator.categorizationExamplesProvider)(client);
    const resp = await validateCategoryExamples(indexPatternTitle, query, size, field, timeField, start, end, analyzer !== null && analyzer !== void 0 ? analyzer : {}, runtimeMappings, indicesOptions, includeExamples);
    return response.ok({
      body: resp
    });
  } catch (e) {
    return response.customError((0, _error_wrapper.wrapError)(e));
  }
};
exports.routeHandlerFactory = routeHandlerFactory;