"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableInputTracker = exports.ChartGridEmbeddableWrapper = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _react2 = require("@emotion/react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_reload = require("../hooks/use_reload");
var _change_point_detection_context = require("../components/change_point_detection/change_point_detection_context");
var _use_filters_query = require("../hooks/use_filters_query");
var _use_data_source = require("../hooks/use_data_source");
var _use_aiops_app_context = require("../hooks/use_aiops_app_context");
var _use_time_buckets = require("../hooks/use_time_buckets");
var _search_utils = require("../application/utils/search_utils");
var _use_change_point_agg_request = require("../components/change_point_detection/use_change_point_agg_request");
var _charts_grid = require("../components/change_point_detection/charts_grid");
var _no_change_points_warning = require("../components/change_point_detection/no_change_points_warning");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultSort = {
  field: 'p_value',
  direction: 'asc'
};
const EmbeddableInputTracker = ({
  input$,
  initialInput,
  reload$,
  onOutputChange,
  onRenderComplete,
  onLoading,
  onError
}) => {
  var _initialInput$lastRel;
  const input = (0, _useObservable.default)(input$, initialInput);
  const [manualReload$] = (0, _react.useState)(new _rxjs.BehaviorSubject((_initialInput$lastRel = initialInput.lastReloadRequestTime) !== null && _initialInput$lastRel !== void 0 ? _initialInput$lastRel : Date.now()));
  (0, _react.useEffect)(function updateManualReloadSubject() {
    if (input.lastReloadRequestTime === initialInput.lastReloadRequestTime || !input.lastReloadRequestTime) return;
    manualReload$.next(input.lastReloadRequestTime);
  }, [input.lastReloadRequestTime, initialInput.lastReloadRequestTime, manualReload$]);
  const resultObservable$ = (0, _react.useMemo)(() => {
    return (0, _rxjs.combineLatest)([reload$, manualReload$]).pipe((0, _operators.map)(([reload, manualReload]) => Math.max(reload, manualReload)), (0, _operators.distinctUntilChanged)());
  }, [manualReload$, reload$]);
  return /*#__PURE__*/_react.default.createElement(_use_reload.ReloadContextProvider, {
    reload$: resultObservable$
  }, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContextProvider, {
    dataViewId: input.dataViewId
  }, /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionControlsContextProvider, null, /*#__PURE__*/_react.default.createElement(_use_filters_query.FilterQueryContextProvider, {
    timeRange: input.timeRange
  }, /*#__PURE__*/_react.default.createElement(ChartGridEmbeddableWrapper, {
    timeRange: input.timeRange,
    fn: input.fn,
    metricField: input.metricField,
    splitField: input.splitField,
    maxSeriesToPlot: input.maxSeriesToPlot,
    dataViewId: input.dataViewId,
    partitions: input.partitions,
    onLoading: onLoading,
    onRenderComplete: onRenderComplete,
    onError: onError,
    onChange: input.onChange,
    emptyState: input.emptyState
  })))));
};

/**
 * Grid component wrapper for embeddable.
 *
 * @param timeRange
 * @param fn
 * @param metricField
 * @param maxSeriesToPlot
 * @param splitField
 * @param partitions
 * @constructor
 */
exports.EmbeddableInputTracker = EmbeddableInputTracker;
const ChartGridEmbeddableWrapper = ({
  fn,
  metricField,
  maxSeriesToPlot,
  splitField,
  partitions,
  onError,
  onLoading,
  onRenderComplete,
  onChange,
  emptyState
}) => {
  const {
    filters,
    query,
    timeRange
  } = (0, _use_filters_query.useFilerQueryUpdates)();
  const fieldConfig = (0, _react.useMemo)(() => {
    return {
      fn,
      metricField,
      splitField
    };
  }, [fn, metricField, splitField]);
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const {
    uiSettings
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const timeBuckets = (0, _use_time_buckets.useTimeBuckets)();
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const interval = (0, _react.useMemo)(() => {
    timeBuckets.setInterval('auto');
    timeBuckets.setBounds(timefilter.calculateBounds(timeRange));
    return timeBuckets.getInterval().expression;
  }, [timeRange, timeBuckets, timefilter]);
  const combinedQuery = (0, _react.useMemo)(() => {
    var _mergedQuery$bool;
    const mergedQuery = (0, _search_utils.createMergedEsQuery)(query, filters, dataView, uiSettings);
    if (!Array.isArray((_mergedQuery$bool = mergedQuery.bool) === null || _mergedQuery$bool === void 0 ? void 0 : _mergedQuery$bool.filter)) {
      if (!mergedQuery.bool) {
        mergedQuery.bool = {};
      }
      mergedQuery.bool.filter = [];
    }
    mergedQuery.bool.filter.push({
      range: {
        [dataView.timeFieldName]: {
          from: timeRange.from,
          to: timeRange.to
        }
      }
    });
    if (Array.isArray(partitions) && partitions.length > 0 && fieldConfig.splitField) {
      var _mergedQuery$bool2;
      (_mergedQuery$bool2 = mergedQuery.bool) === null || _mergedQuery$bool2 === void 0 ? void 0 : _mergedQuery$bool2.filter.push({
        terms: {
          [fieldConfig.splitField]: partitions
        }
      });
    }
    return mergedQuery;
  }, [dataView, fieldConfig.splitField, filters, partitions, query, timeRange.from, timeRange.to, uiSettings]);
  const requestParams = (0, _react.useMemo)(() => {
    return {
      interval
    };
  }, [interval]);
  const {
    results,
    isLoading
  } = (0, _use_change_point_agg_request.useChangePointResults)(fieldConfig, requestParams, combinedQuery, 10000);
  (0, _react.useEffect)(() => {
    if (isLoading) {
      onLoading();
    }
  }, [onLoading, isLoading]);
  const changePoints = (0, _react.useMemo)(() => {
    let resultChangePoints = results.sort((a, b) => {
      if (defaultSort.direction === 'asc') {
        return a[defaultSort.field] - b[defaultSort.field];
      } else {
        return b[defaultSort.field] - a[defaultSort.field];
      }
    });
    if (maxSeriesToPlot) {
      resultChangePoints = resultChangePoints.slice(0, maxSeriesToPlot);
    }
    if (onChange) {
      onChange(resultChangePoints);
    }
    return resultChangePoints;
  }, [results, maxSeriesToPlot, onChange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        overflow: auto;
        width: 100%;
      `
  }, changePoints.length > 0 ? /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    changePoints: changePoints.map(r => ({
      ...r,
      ...fieldConfig
    })),
    interval: requestParams.interval,
    onRenderComplete: onRenderComplete
  }) : emptyState ? emptyState : /*#__PURE__*/_react.default.createElement(_no_change_points_warning.NoChangePointsWarning, {
    onRenderComplete: onRenderComplete
  }));
};
exports.ChartGridEmbeddableWrapper = ChartGridEmbeddableWrapper;