"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormControls = exports.ChangePointChartInitializer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _lodash = require("lodash");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _fieldTypes = require("@kbn/field-types");
var _partitions_selector = require("../components/change_point_detection/partitions_selector");
var _const = require("./const");
var _max_series_control = require("../components/change_point_detection/max_series_control");
var _split_field_selector = require("../components/change_point_detection/split_field_selector");
var _metric_field_selector = require("../components/change_point_detection/metric_field_selector");
var _change_point_detection_context = require("../components/change_point_detection/change_point_detection_context");
var _use_aiops_app_context = require("../hooks/use_aiops_app_context");
var _function_picker = require("../components/change_point_detection/function_picker");
var _use_data_source = require("../hooks/use_data_source");
var _constants = require("../components/change_point_detection/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChangePointChartInitializer = ({
  initialInput,
  onCreate,
  onCancel
}) => {
  var _initialInput$dataVie;
  const {
    unifiedSearch: {
      ui: {
        IndexPatternSelect
      }
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const [dataViewId, setDataViewId] = (0, _react.useState)((_initialInput$dataVie = initialInput === null || initialInput === void 0 ? void 0 : initialInput.dataViewId) !== null && _initialInput$dataVie !== void 0 ? _initialInput$dataVie : '');
  const [formInput, setFormInput] = (0, _react.useState)((0, _lodash.pick)(initialInput !== null && initialInput !== void 0 ? initialInput : {}, ['fn', 'metricField', 'splitField', 'maxSeriesToPlot', 'partitions']));
  const [isFormValid, setIsFormValid] = (0, _react.useState)(true);
  const updatedProps = (0, _react.useMemo)(() => {
    return {
      ...formInput,
      title: (0, _mlIsPopulatedObject.isPopulatedObject)(formInput) ? _i18n.i18n.translate('xpack.aiops.changePointDetection.attachmentTitle', {
        defaultMessage: 'Change point: {function}({metric}){splitBy}',
        values: {
          function: formInput.fn,
          metric: formInput === null || formInput === void 0 ? void 0 : formInput.metricField,
          splitBy: formInput !== null && formInput !== void 0 && formInput.splitField ? _i18n.i18n.translate('xpack.aiops.changePointDetection.splitByTitle', {
            defaultMessage: ' split by "{splitField}"',
            values: {
              splitField: formInput.splitField
            }
          }) : ''
        }
      }) : '',
      dataViewId
    };
  }, [formInput, dataViewId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCancel,
    "data-test-subj": 'aiopsChangePointChartEmbeddableInitializer'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableChangePointChart.modalTitle",
    defaultMessage: "Change point charts configuration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.aiops.embeddableChangePointChart.dataViewLabel', {
      defaultMessage: 'Data view'
    })
  }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
    autoFocus: !dataViewId,
    fullWidth: true,
    compressed: true,
    indexPatternId: dataViewId,
    placeholder: _i18n.i18n.translate('xpack.aiops.embeddableChangePointChart.dataViewSelectorPlaceholder', {
      defaultMessage: 'Select data view'
    }),
    onChange: newId => {
      setDataViewId(newId !== null && newId !== void 0 ? newId : '');
    }
  })), /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContextProvider, {
    dataViewId: dataViewId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: 's'
  }), /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionControlsContextProvider, null, /*#__PURE__*/_react.default.createElement(FormControls, {
    formInput: formInput,
    onChange: setFormInput,
    onValidationChange: setIsFormValid
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "aiopsChangePointChartsInitializerCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableChangePointChart.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "aiopsChangePointChartsInitializerConfirmButton",
    isDisabled: !isFormValid || !dataViewId,
    onClick: onCreate.bind(null, updatedProps),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableChangePointChart.setupModal.confirmButtonLabel",
    defaultMessage: "Confirm configurations"
  }))));
};
exports.ChangePointChartInitializer = ChangePointChartInitializer;
const FormControls = ({
  formInput,
  onChange,
  onValidationChange
}) => {
  var _formInput$partitions, _formInput$partitions2;
  const {
    metricFieldOptions,
    splitFieldsOptions
  } = (0, _change_point_detection_context.useChangePointDetectionControlsContext)();
  const prevMetricFieldOptions = (0, _usePrevious.default)(metricFieldOptions);
  const enableSearch = (0, _react.useMemo)(() => {
    const field = splitFieldsOptions.find(v => v.name === (formInput === null || formInput === void 0 ? void 0 : formInput.splitField));
    if (field && field.esTypes) {
      var _field$esTypes;
      return (_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.some(t => t === _fieldTypes.ES_FIELD_TYPES.KEYWORD);
    } else {
      return false;
    }
  }, [splitFieldsOptions, formInput === null || formInput === void 0 ? void 0 : formInput.splitField]);
  (0, _react.useEffect)(function setDefaultOnDataViewChange() {
    var _metricFieldOptions$2;
    if (!(0, _mlIsPopulatedObject.isPopulatedObject)(formInput)) {
      var _metricFieldOptions$;
      onChange({
        fn: _constants.DEFAULT_AGG_FUNCTION,
        metricField: (_metricFieldOptions$ = metricFieldOptions[0]) === null || _metricFieldOptions$ === void 0 ? void 0 : _metricFieldOptions$.name,
        splitField: undefined,
        partitions: undefined,
        maxSeriesToPlot: _const.DEFAULT_SERIES
      });
      return;
    }
    if (!prevMetricFieldOptions || metricFieldOptions === prevMetricFieldOptions) return;
    onChange({
      fn: formInput.fn,
      metricField: (_metricFieldOptions$2 = metricFieldOptions[0]) === null || _metricFieldOptions$2 === void 0 ? void 0 : _metricFieldOptions$2.name,
      splitField: undefined,
      partitions: undefined,
      maxSeriesToPlot: formInput.maxSeriesToPlot
    });
  }, [metricFieldOptions, prevMetricFieldOptions, formInput, onChange]);
  const updateCallback = (0, _react.useCallback)(update => {
    onChange({
      ...formInput,
      ...update
    });
  }, [formInput, onChange]);
  if (!(0, _mlIsPopulatedObject.isPopulatedObject)(formInput)) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.embeddableChangePointChart.functionLabel",
      defaultMessage: "Function"
    })
  }, /*#__PURE__*/_react.default.createElement(_function_picker.FunctionPicker, {
    value: formInput.fn,
    onChange: v => updateCallback({
      fn: v
    })
  })), /*#__PURE__*/_react.default.createElement(_metric_field_selector.MetricFieldSelector, {
    inline: false,
    value: formInput.metricField,
    onChange: v => updateCallback({
      metricField: v
    })
  }), /*#__PURE__*/_react.default.createElement(_split_field_selector.SplitFieldSelector, {
    inline: false,
    value: formInput.splitField,
    onChange: v => updateCallback({
      splitField: v
    })
  }), formInput.splitField ? /*#__PURE__*/_react.default.createElement(_partitions_selector.PartitionsSelector, {
    value: (_formInput$partitions = formInput.partitions) !== null && _formInput$partitions !== void 0 ? _formInput$partitions : [],
    onChange: v => updateCallback({
      partitions: v
    }),
    splitField: formInput.splitField,
    enableSearch: enableSearch
  }) : null, /*#__PURE__*/_react.default.createElement(_max_series_control.MaxSeriesControl, {
    inline: false,
    disabled: !!(formInput !== null && formInput !== void 0 && (_formInput$partitions2 = formInput.partitions) !== null && _formInput$partitions2 !== void 0 && _formInput$partitions2.length),
    value: formInput.maxSeriesToPlot,
    onChange: v => updateCallback({
      maxSeriesToPlot: v
    }),
    onValidationChange: result => onValidationChange(result === null)
  }));
};
exports.FormControls = FormControls;