"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisContent = void 0;
exports.getDocumentCountStatsSplitLabel = getDocumentCountStatsSplitLabel;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _aiopsUtils = require("@kbn/aiops-utils");
var _use_data = require("../../../hooks/use_data");
var _document_count_content = require("../../document_count_content/document_count_content");
var _log_rate_analysis_results = require("../log_rate_analysis_results");
var _log_rate_analysis_results_table_row_provider = require("../../log_rate_analysis_results_table/log_rate_analysis_results_table_row_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SEARCH_QUERY = {
  match_all: {}
};
const DEFAULT_SEARCH_BAR_QUERY = {
  bool: {
    filter: [],
    must: [{
      match_all: {}
    }],
    must_not: []
  }
};
function getDocumentCountStatsSplitLabel(significantItem, group) {
  if (significantItem) {
    return `${significantItem === null || significantItem === void 0 ? void 0 : significantItem.fieldName}:${significantItem === null || significantItem === void 0 ? void 0 : significantItem.fieldValue}`;
  } else if (group) {
    return _i18n.i18n.translate('xpack.aiops.logRateAnalysis.page.documentCountStatsSplitGroupLabel', {
      defaultMessage: 'Selected group'
    });
  }
}
const LogRateAnalysisContent = ({
  dataView,
  setGlobalState,
  initialAnalysisStart: incomingInitialAnalysisStart,
  timeRange,
  esSearchQuery = DEFAULT_SEARCH_QUERY,
  stickyHistogram,
  barColorOverride,
  barHighlightColorOverride,
  onAnalysisCompleted,
  onWindowParametersChange,
  embeddingOrigin
}) => {
  const [windowParameters, setWindowParameters] = (0, _react.useState)();
  const [initialAnalysisStart, setInitialAnalysisStart] = (0, _react.useState)(incomingInitialAnalysisStart);
  const [isBrushCleared, setIsBrushCleared] = (0, _react.useState)(true);
  const [logRateAnalysisType, setLogRateAnalysisType] = (0, _react.useState)(_aiopsUtils.LOG_RATE_ANALYSIS_TYPE.SPIKE);
  (0, _react.useEffect)(() => {
    setIsBrushCleared(windowParameters === undefined);
  }, [windowParameters]);

  // Window parameters stored in the url state use this components
  // `initialAnalysisStart` prop to set the initial params restore from url state.
  // To avoid a loop with window parameters being passed around on load,
  // the following ref and useEffect are used to check wether it's safe to call
  // the `onWindowParametersChange` callback.
  const windowParametersTouched = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    // Don't continue if window parameters were not touched yet.
    // Because they can be reset to `undefined` at a later stage again when a user
    // clears the selections, we cannot rely solely on checking if they are
    // `undefined`, we need the additional ref to update on the first change.
    if (!windowParametersTouched.current && windowParameters === undefined) {
      return;
    }
    windowParametersTouched.current = true;
    if (onWindowParametersChange) {
      onWindowParametersChange(windowParameters);
    }
  }, [onWindowParametersChange, windowParameters]);

  // Checks if `esSearchQuery` is the default empty query passed on from the search bar
  // and if that's the case fall back to a simpler match all query.
  const searchQuery = (0, _react.useMemo)(() => (0, _lodash.isEqual)(esSearchQuery, DEFAULT_SEARCH_BAR_QUERY) ? DEFAULT_SEARCH_QUERY : esSearchQuery, [esSearchQuery]);
  const {
    currentSelectedSignificantItem,
    currentSelectedGroup,
    setPinnedSignificantItem,
    setPinnedGroup,
    setSelectedSignificantItem,
    setSelectedGroup
  } = (0, _log_rate_analysis_results_table_row_provider.useLogRateAnalysisResultsTableRowContext)();
  const {
    documentStats,
    earliest,
    latest
  } = (0, _use_data.useData)(dataView, 'log_rate_analysis', searchQuery, setGlobalState, currentSelectedSignificantItem, currentSelectedGroup, undefined, timeRange);
  const {
    sampleProbability,
    totalCount,
    documentCountStats,
    documentCountStatsCompare
  } = documentStats;
  function brushSelectionUpdate(windowParametersUpdate, force, logRateAnalysisTypeUpdate) {
    if (!isBrushCleared || force) {
      setWindowParameters(windowParametersUpdate);
    }
    if (force) {
      setIsBrushCleared(false);
    }
    setLogRateAnalysisType(logRateAnalysisTypeUpdate);
  }
  function clearSelection() {
    setWindowParameters(undefined);
    setPinnedSignificantItem(null);
    setPinnedGroup(null);
    setSelectedSignificantItem(null);
    setSelectedGroup(null);
    setIsBrushCleared(true);
    setInitialAnalysisStart(undefined);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, documentCountStats !== undefined && /*#__PURE__*/_react.default.createElement(_document_count_content.DocumentCountContent, {
    brushSelectionUpdateHandler: brushSelectionUpdate,
    documentCountStats: documentCountStats,
    documentCountStatsSplit: documentCountStatsCompare,
    documentCountStatsSplitLabel: getDocumentCountStatsSplitLabel(currentSelectedSignificantItem, currentSelectedGroup),
    isBrushCleared: isBrushCleared,
    totalCount: totalCount,
    sampleProbability: sampleProbability,
    initialAnalysisStart: initialAnalysisStart,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), earliest !== undefined && latest !== undefined && windowParameters !== undefined && /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results.LogRateAnalysisResults, {
    dataView: dataView,
    analysisType: logRateAnalysisType,
    earliest: earliest,
    isBrushCleared: isBrushCleared,
    latest: latest,
    stickyHistogram: stickyHistogram,
    onReset: clearSelection,
    sampleProbability: sampleProbability,
    searchQuery: searchQuery,
    windowParameters: windowParameters,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    onAnalysisCompleted: onAnalysisCompleted,
    embeddingOrigin: embeddingOrigin
  }), windowParameters === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "subdued",
    hasShadow: false,
    hasBorder: false,
    css: {
      minWidth: '100%'
    },
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.emptyPromptTitle",
      defaultMessage: "Click a spike or dip in the histogram chart to start the analysis."
    })),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.emptyPromptBody",
      defaultMessage: "The log rate analysis feature identifies statistically significant field/value combinations that contribute to a log rate spike or dip."
    })),
    "data-test-subj": "aiopsNoWindowParametersEmptyPrompt"
  }));
};
exports.LogRateAnalysisContent = LogRateAnalysisContent;