"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MiniChartPreview = exports.ChangePointsTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _esQuery = require("@kbn/es-query");
var _no_change_points_warning = require("./no_change_points_warning");
var _use_data_source = require("../../hooks/use_data_source");
var _use_common_chart_props = require("./use_common_chart_props");
var _change_point_detection_context = require("./change_point_detection_context");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFilterConfig(index, item, negate) {
  return {
    meta: {
      disabled: false,
      negate,
      alias: null,
      index,
      key: `${item.group.name}_${item.group.value}`,
      // @ts-ignore FilterMeta type definition misses the field property
      field: item.group.name,
      params: {
        query: item.group.value
      },
      type: 'phrase'
    },
    query: {
      match_phrase: {
        [item.group.name]: item.group.value
      }
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    }
  };
}
const ChangePointsTable = ({
  isLoading,
  annotations,
  fieldConfig,
  onSelectionChange
}) => {
  const {
    fieldFormats,
    data: {
      query: {
        filterManager
      }
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const dateFormatter = (0, _react.useMemo)(() => fieldFormats.deserialize({
    id: 'date'
  }), [fieldFormats]);
  const defaultSorting = {
    sort: {
      field: 'p_value',
      // Lower p_value indicates a bigger change point, hence the asc sorting
      direction: 'asc'
    }
  };
  const hasActions = fieldConfig.splitField !== undefined;
  const {
    bucketInterval
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  const columns = [{
    id: 'timestamp',
    field: 'timestamp',
    'data-test-subj': 'aiopsChangePointTimestamp',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.timeColumn', {
      defaultMessage: 'Time'
    }),
    sortable: true,
    truncateText: false,
    width: '230px',
    render: timestamp => dateFormatter.convert(timestamp)
  }, {
    id: 'preview',
    'data-test-subj': 'aiopsChangePointPreview',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.previewColumn', {
      defaultMessage: 'Preview'
    }),
    align: 'center',
    width: '200px',
    height: '80px',
    truncateText: false,
    valign: 'middle',
    css: {
      // Extra specificity needed here to override Sass styles
      // TODO: Can be removed once EuiTable has been converted to Emotion
      ['&.euiTableCellContent']: {
        display: 'block',
        padding: 0
      }
    },
    render: annotation => {
      return /*#__PURE__*/_react.default.createElement(MiniChartPreview, {
        annotation: annotation,
        fieldConfig: fieldConfig,
        interval: bucketInterval.expression
      });
    }
  }, {
    id: 'type',
    'data-test-subj': 'aiopsChangePointType',
    field: 'type',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.typeColumn', {
      defaultMessage: 'Type'
    }),
    sortable: true,
    truncateText: false,
    render: type => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, type)
  }, {
    id: 'pValue',
    'data-test-subj': 'aiopsChangePointPValue',
    field: 'p_value',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.aiops.changePointDetection.pValueTooltip', {
        defaultMessage: 'Indicates how extreme the change is. Lower values indicate greater change.'
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.aiops.changePointDetection.pValueLabel', {
      defaultMessage: 'p-value'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    sortable: true,
    truncateText: false,
    render: pValue => pValue.toPrecision(3)
  }, ...(fieldConfig.splitField ? [{
    id: 'groupName',
    'data-test-subj': 'aiopsChangePointGroupName',
    field: 'group.name',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.fieldNameColumn', {
      defaultMessage: 'Field name'
    }),
    truncateText: false
  }, {
    id: 'groupValue',
    'data-test-subj': 'aiopsChangePointGroupValue',
    field: 'group.value',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.fieldValueColumn', {
      defaultMessage: 'Field value'
    }),
    truncateText: false,
    sortable: true
  }, {
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.actionsColumn', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _i18n.i18n.translate('xpack.aiops.changePointDetection.actions.filterForValueAction', {
        defaultMessage: 'Filter for value'
      }),
      description: _i18n.i18n.translate('xpack.aiops.changePointDetection.actions.filterForValueAction', {
        defaultMessage: 'Filter for value'
      }),
      icon: 'plusInCircle',
      color: 'primary',
      type: 'icon',
      onClick: item => {
        filterManager.addFilters(getFilterConfig(dataView.id, item, false));
      },
      isPrimary: true,
      'data-test-subj': 'aiopsChangePointFilterForValue'
    }, {
      name: _i18n.i18n.translate('xpack.aiops.changePointDetection.actions.filterOutValueAction', {
        defaultMessage: 'Filter out value'
      }),
      description: _i18n.i18n.translate('xpack.aiops.changePointDetection.actions.filterOutValueAction', {
        defaultMessage: 'Filter out value'
      }),
      icon: 'minusInCircle',
      color: 'primary',
      type: 'icon',
      onClick: item => {
        filterManager.addFilters(getFilterConfig(dataView.id, item, true));
      },
      isPrimary: true,
      'data-test-subj': 'aiopsChangePointFilterOutValue'
    }]
  }] : [])];
  const selectionValue = (0, _react.useMemo)(() => {
    return {
      selectable: item => true,
      onSelectionChange: selection => {
        onSelectionChange(selection.map(s => {
          return {
            ...s,
            ...fieldConfig
          };
        }));
      }
    };
  }, [fieldConfig, onSelectionChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: 'id',
    selection: selectionValue,
    loading: isLoading,
    "data-test-subj": `aiopsChangePointResultsTable ${isLoading ? 'loading' : 'loaded'}`,
    items: annotations,
    columns: columns,
    pagination: {
      pageSizeOptions: [5, 10, 15]
    },
    sorting: defaultSorting,
    hasActions: hasActions,
    rowProps: item => ({
      'data-test-subj': `aiopsChangePointResultsTableRow row-${item.id}`
    }),
    message: isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "search",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.changePointDetection.fetchingChangePointsTitle",
        defaultMessage: "Fetching change points..."
      }))
    }) : /*#__PURE__*/_react.default.createElement(_no_change_points_warning.NoChangePointsWarning, null)
  });
};
exports.ChangePointsTable = ChangePointsTable;
const MiniChartPreview = ({
  fieldConfig,
  annotation
}) => {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    bucketInterval
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  const {
    filters,
    query,
    attributes,
    timeRange
  } = (0, _use_common_chart_props.useCommonChartProps)({
    annotation,
    fieldConfig,
    previewMode: true,
    bucketInterval: bucketInterval.expression
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'aiopChangePointPreviewChart'
  }, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: `mini_changePointChart_${annotation.group ? annotation.group.value : annotation.label}`,
    style: {
      height: 80
    },
    timeRange: timeRange,
    query: query,
    filters: filters
    // @ts-ignore
    ,
    attributes: attributes,
    renderMode: 'preview',
    executionContext: {
      type: 'aiops_change_point_detection_chart',
      name: 'Change point detection'
    }
  }));
};
exports.MiniChartPreview = MiniChartPreview;