"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPage = SettingsPage;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_app_context = require("../../hooks/use_app_context");
var _settings_tab = require("./settings_tab");
var _knowledge_base_tab = require("./knowledge_base_tab");
var _use_observability_management_params = require("../../hooks/use_observability_management_params");
var _use_observability_management_router = require("../../hooks/use_observability_management_router");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SettingsPage() {
  var _tabs$find, _tabs$find2;
  const {
    application: {
      navigateToApp
    },
    serverless,
    setBreadcrumbs
  } = (0, _use_app_context.useAppContext)();
  const router = (0, _use_observability_management_router.useObservabilityAIAssistantManagementRouter)();
  const {
    query: {
      tab
    }
  } = (0, _use_observability_management_params.useObservabilityAIAssistantManagementRouterParams)('/');
  (0, _react.useEffect)(() => {
    if (serverless) {
      serverless.setBreadcrumbs([{
        text: _i18n.i18n.translate('aiAssistantManagementObservability.breadcrumb.serverless.observability', {
          defaultMessage: 'AI Assistant for Observability Settings'
        })
      }]);
    } else {
      setBreadcrumbs([{
        text: _i18n.i18n.translate('aiAssistantManagementObservability.breadcrumb.index', {
          defaultMessage: 'AI Assistants'
        }),
        onClick: e => {
          e.preventDefault();
          navigateToApp('management', {
            path: '/kibana/aiAssistantManagementSelection'
          });
        }
      }, {
        text: _i18n.i18n.translate('aiAssistantManagementObservability.breadcrumb.observability', {
          defaultMessage: 'Observability'
        })
      }]);
    }
  }, [navigateToApp, serverless, setBreadcrumbs]);
  const tabs = [{
    id: 'settings',
    name: _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.settingsLabel', {
      defaultMessage: 'Settings'
    }),
    content: /*#__PURE__*/_react.default.createElement(_settings_tab.SettingsTab, null)
  }, {
    id: 'knowledge_base',
    name: _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.knowledgeBaseLabel', {
      defaultMessage: 'Knowledge base'
    }),
    content: /*#__PURE__*/_react.default.createElement(_knowledge_base_tab.KnowledgeBaseTab, null)
  }];
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tab ? (_tabs$find = tabs.find(t => t.id === tab)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.id : tabs[0].id);
  const selectedTabContent = (_tabs$find2 = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find2 === void 0 ? void 0 : _tabs$find2.content;
  const onSelectedTabChanged = id => {
    setSelectedTabId(id);
    router.push('/', {
      path: '/',
      query: {
        tab: id
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.h2.settingsLabel', {
    defaultMessage: 'Settings'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "settingsPageTabs"
  }, tabs.map((t, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: index,
    "data-test-subj": `settingsPageTab-${t.id}`,
    onClick: () => onSelectedTabChanged(t.id),
    isSelected: t.id === selectedTabId
  }, t.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), selectedTabContent, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
}