"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _get_all = require("./connector/get_all");
var _list_types = require("./connector/list_types");
var _create = require("./create");
var _delete = require("./delete");
var _execute = require("./execute");
var _get = require("./connector/get");
var _update = require("./update");
var _get_oauth_access_token = require("./get_oauth_access_token");
var _legacy = require("./legacy");
var _get_global_execution_logs = require("./get_global_execution_logs");
var _get_global_execution_kpi = require("./get_global_execution_kpi");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineRoutes(opts) {
  const {
    router,
    licenseState,
    actionsConfigUtils,
    usageCounter
  } = opts;
  (0, _legacy.defineLegacyRoutes)(router, licenseState, usageCounter);
  (0, _create.createActionRoute)(router, licenseState);
  (0, _delete.deleteActionRoute)(router, licenseState);
  (0, _get.getConnectorRoute)(router, licenseState);
  (0, _get_all.getAllConnectorsRoute)(router, licenseState);
  (0, _update.updateActionRoute)(router, licenseState);
  (0, _list_types.listTypesRoute)(router, licenseState);
  (0, _execute.executeActionRoute)(router, licenseState);
  (0, _get_global_execution_logs.getGlobalExecutionLogRoute)(router, licenseState);
  (0, _get_global_execution_kpi.getGlobalExecutionKPIRoute)(router, licenseState);
  (0, _get_oauth_access_token.getOAuthAccessToken)(router, licenseState, actionsConfigUtils);
}