"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ACTION_SAVED_OBJECT_TYPE", {
  enumerable: true,
  get: function () {
    return _saved_objects.ACTION_SAVED_OBJECT_TYPE;
  }
});
Object.defineProperty(exports, "CaseConnector", {
  enumerable: true,
  get: function () {
    return _case.CaseConnector;
  }
});
Object.defineProperty(exports, "SubActionConnector", {
  enumerable: true,
  get: function () {
    return _sub_action_connector.SubActionConnector;
  }
});
Object.defineProperty(exports, "UnsecuredActionsClient", {
  enumerable: true,
  get: function () {
    return _unsecured_actions_client.UnsecuredActionsClient;
  }
});
Object.defineProperty(exports, "asHttpRequestExecutionSource", {
  enumerable: true,
  get: function () {
    return _lib.asHttpRequestExecutionSource;
  }
});
Object.defineProperty(exports, "asNotificationExecutionSource", {
  enumerable: true,
  get: function () {
    return _lib.asNotificationExecutionSource;
  }
});
Object.defineProperty(exports, "asSavedObjectExecutionSource", {
  enumerable: true,
  get: function () {
    return _lib.asSavedObjectExecutionSource;
  }
});
exports.plugin = exports.config = void 0;
Object.defineProperty(exports, "urlAllowListValidator", {
  enumerable: true,
  get: function () {
    return _helpers.urlAllowListValidator;
  }
});
var _lodash = require("lodash");
var _config = require("./config");
var _unsecured_actions_client = require("./unsecured_actions_client/unsecured_actions_client");
var _lib = require("./lib");
var _saved_objects = require("./constants/saved_objects");
var _sub_action_connector = require("./sub_action_framework/sub_action_connector");
var _case = require("./sub_action_framework/case");
var _helpers = require("./sub_action_framework/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const plugin = async initContext => {
  const {
    ActionsPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new ActionsPlugin(initContext);
};
exports.plugin = plugin;
const config = {
  schema: _config.configSchema,
  exposeToBrowser: {
    email: {
      domain_allowlist: true
    }
  },
  deprecations: ({
    renameFromRoot,
    unused
  }) => [renameFromRoot('xpack.actions.whitelistedHosts', 'xpack.actions.allowedHosts', {
    level: 'warning'
  }), (settings, fromPath, addDeprecation) => {
    var _actions$customHostSe;
    const actions = (0, _lodash.get)(settings, fromPath);
    const customHostSettings = (_actions$customHostSe = actions === null || actions === void 0 ? void 0 : actions.customHostSettings) !== null && _actions$customHostSe !== void 0 ? _actions$customHostSe : [];
    if (customHostSettings.find(customHostSchema => {
      var _customHostSchema$ssl;
      return customHostSchema.hasOwnProperty('ssl') && ((_customHostSchema$ssl = customHostSchema.ssl) === null || _customHostSchema$ssl === void 0 ? void 0 : _customHostSchema$ssl.hasOwnProperty('rejectUnauthorized'));
    })) {
      addDeprecation({
        level: 'warning',
        configPath: 'xpack.actions.customHostSettings.ssl.rejectUnauthorized',
        message: `"xpack.actions.customHostSettings[<index>].ssl.rejectUnauthorized" is deprecated.` + `Use "xpack.actions.customHostSettings[<index>].ssl.verificationMode" instead, ` + `with the setting "verificationMode:full" eql to "rejectUnauthorized:true", ` + `and "verificationMode:none" eql to "rejectUnauthorized:false".`,
        correctiveActions: {
          manualSteps: [`Remove "xpack.actions.customHostSettings[<index>].ssl.rejectUnauthorized" from your kibana configs.`, `Use "xpack.actions.customHostSettings[<index>].ssl.verificationMode" ` + `with the setting "verificationMode:full" eql to "rejectUnauthorized:true", ` + `and "verificationMode:none" eql to "rejectUnauthorized:false".`]
        }
      });
      return {
        unset: [{
          path: `xpack.actions.customHostSettings.ssl.rejectUnauthorized`
        }]
      };
    }
  }, (settings, fromPath, addDeprecation) => {
    const actions = (0, _lodash.get)(settings, fromPath);
    if (actions !== null && actions !== void 0 && actions.hasOwnProperty('rejectUnauthorized')) {
      addDeprecation({
        level: 'warning',
        configPath: `${fromPath}.rejectUnauthorized`,
        message: `"xpack.actions.rejectUnauthorized" is deprecated. Use "xpack.actions.ssl.verificationMode" instead, ` + `with the setting "verificationMode:full" eql to "rejectUnauthorized:true", ` + `and "verificationMode:none" eql to "rejectUnauthorized:false".`,
        correctiveActions: {
          manualSteps: [`Remove "xpack.actions.rejectUnauthorized" from your kibana configs.`, `Use "xpack.actions.ssl.verificationMode" ` + `with the setting "verificationMode:full" eql to "rejectUnauthorized:true", ` + `and "verificationMode:none" eql to "rejectUnauthorized:false".`]
        }
      });
      return {
        unset: [{
          path: `xpack.actions.rejectUnauthorized`
        }]
      };
    }
  }, (settings, fromPath, addDeprecation) => {
    const actions = (0, _lodash.get)(settings, fromPath);
    if (actions !== null && actions !== void 0 && actions.hasOwnProperty('proxyRejectUnauthorizedCertificates')) {
      addDeprecation({
        level: 'warning',
        configPath: `${fromPath}.proxyRejectUnauthorizedCertificates`,
        message: `"xpack.actions.proxyRejectUnauthorizedCertificates" is deprecated. Use "xpack.actions.ssl.proxyVerificationMode" instead, ` + `with the setting "proxyVerificationMode:full" eql to "rejectUnauthorized:true",` + `and "proxyVerificationMode:none" eql to "rejectUnauthorized:false".`,
        correctiveActions: {
          manualSteps: [`Remove "xpack.actions.proxyRejectUnauthorizedCertificates" from your kibana configs.`, `Use "xpack.actions.ssl.proxyVerificationMode" ` + `with the setting "proxyVerificationMode:full" eql to "rejectUnauthorized:true",` + `and "proxyVerificationMode:none" eql to "rejectUnauthorized:false".`]
        }
      });
      return {
        unset: [{
          path: `xpack.actions.proxyRejectUnauthorizedCertificates`
        }]
      };
    }
  }]
};
exports.config = config;