"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiGlobalStyles = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _mixins = require("../mixins");
var _functions = require("../functions");
var _color = require("../../services/color");
var _theme = require("../../services/theme");
var _reset = require("./reset");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectDestructuringEmpty(obj) { if (obj == null) throw new TypeError("Cannot destructure " + obj); } /*
                                                                                                                * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                * Side Public License, v 1.
                                                                                                                */
var EuiGlobalStyles = function EuiGlobalStyles(_ref) {
  _objectDestructuringEmpty(_ref);
  var euiThemeContext = (0, _theme.useEuiTheme)();
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var base = euiTheme.base,
    colors = euiTheme.colors,
    font = euiTheme.font;

  /**
   * Declaring the top level scrollbar colors to match the theme also requires setting the sizes on Chrome
   * so that it knows to use custom styles. Therefore, we just reuse the same scrollbar mixin with thick size.
   */
  var scrollbarStyles = (0, _mixins.euiScrollBarStyles)(euiThemeContext, {
    trackColor: colorMode === 'LIGHT' ? (0, _color.shade)(colors.body, 0.03) : (0, _color.tint)(colors.body, 0.07),
    width: 'auto'
  });

  /**
   * This font reset sets all our base font/typography related properties
   * that are needed to override browser-specific element settings.
   */
  var fontBodyScale = font.scale[font.body.scale];
  var fontReset = {
    fontFamily: font.family,
    fontSize: "".concat(font.defaultUnits === 'px' ? fontBodyScale * base : fontBodyScale).concat(font.defaultUnits),
    lineHeight: base / (fontBodyScale * base),
    fontWeight: font.weight[font.body.weight]
  };

  /**
   * Final styles
   */
  var styles = /*#__PURE__*/(0, _react2.css)(_reset.resetStyles, " html{", scrollbarStyles, " ", fontReset, " text-size-adjust:100%;font-kerning:normal;", (0, _functions.logicalCSS)('height', '100%'), " background-color:", colors.body, ";color:", colors.text, ";}code,pre,kbd,samp{font-family:", font.familyCode, ";}input,textarea,select{", _objectSpread(_objectSpread({}, fontReset), {}, {
    fontSize: '1rem' // Inherit from html root
  }), ";}select:disabled{opacity:1;}button{font-family:", font.family, ";}em{font-style:italic;}strong{font-weight:", font.weight.bold, ";}*:focus{", (0, _mixins.euiFocusRing)(euiThemeContext), ";}::selection{background:", (0, _color.transparentize)(colors.primary, colorMode === 'LIGHT' ? 0.1 : 0.2), ";}a{color:", colors.primaryText, ";&,&:hover,&:focus{text-decoration:none;}}.euiBody-hasPortalContent{position:relative;};label:styles;");
  return (0, _react2.jsx)(_react2.Global, {
    styles: styles
  });
};
exports.EuiGlobalStyles = EuiGlobalStyles;