"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiPaddingSize = exports.useEuiPaddingCSS = exports.euiPaddingSizeCSS = exports.euiPaddingSize = exports.PADDING_SIZES = void 0;
var _react = require("@emotion/react");
var _theme = require("../../services/theme");
var _functions = require("../functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var PADDING_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
exports.PADDING_SIZES = PADDING_SIZES;
var euiPaddingSize = function euiPaddingSize(_ref, size) {
  var euiTheme = _ref.euiTheme;
  switch (size) {
    case 'none':
      return null;
    case 'm':
      return euiTheme.size.base;
    default:
      return euiTheme.size[size];
  }
};
exports.euiPaddingSize = euiPaddingSize;
var euiPaddingSizeCSS = function euiPaddingSizeCSS(euiThemeContext, side) {
  var property = side ? "padding-".concat(_functions.logicalSide[side]) : 'padding';
  return {
    none: null,
    xs: /*#__PURE__*/(0, _react.css)(property, ":", euiPaddingSize(euiThemeContext, 'xs'), ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)(property, ":", euiPaddingSize(euiThemeContext, 's'), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)(property, ":", euiPaddingSize(euiThemeContext, 'm'), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)(property, ":", euiPaddingSize(euiThemeContext, 'l'), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)(property, ":", euiPaddingSize(euiThemeContext, 'xl'), ";;label:xl;")
  };
};
exports.euiPaddingSizeCSS = euiPaddingSizeCSS;
var useEuiPaddingSize = function useEuiPaddingSize(size) {
  var euiTheme = (0, _theme.useEuiTheme)();
  return euiPaddingSize(euiTheme, size);
};
exports.useEuiPaddingSize = useEuiPaddingSize;
var useEuiPaddingCSS = function useEuiPaddingCSS(side) {
  var euiTheme = (0, _theme.useEuiTheme)();
  return euiPaddingSizeCSS(euiTheme, side);
};
exports.useEuiPaddingCSS = useEuiPaddingCSS;