"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mathWithUnits = void 0;
function _wrapRegExp() { _wrapRegExp = function _wrapRegExp(re, groups) { return new BabelRegExp(re, void 0, groups); }; var _super = RegExp.prototype, _groups = new WeakMap(); function BabelRegExp(re, flags, groups) { var _this = new RegExp(re, flags); return _groups.set(_this, groups || _groups.get(re)), _setPrototypeOf(_this, BabelRegExp.prototype); } function buildGroups(result, re) { var g = _groups.get(re); return Object.keys(g).reduce(function (groups, name) { var i = g[name]; if ("number" == typeof i) groups[name] = result[i];else { for (var k = 0; void 0 === result[i[k]] && k + 1 < i.length;) k++; groups[name] = result[i[k]]; } return groups; }, Object.create(null)); } return _inherits(BabelRegExp, RegExp), BabelRegExp.prototype.exec = function (str) { var result = _super.exec.call(this, str); if (result) { result.groups = buildGroups(result, this); var indices = result.indices; indices && (indices.groups = buildGroups(indices, this)); } return result; }, BabelRegExp.prototype[Symbol.replace] = function (str, substitution) { if ("string" == typeof substitution) { var groups = _groups.get(this); return _super[Symbol.replace].call(this, str, substitution.replace(/\$<([^>]+)>/g, function (_, name) { var group = groups[name]; return "$" + (Array.isArray(group) ? group.join("$") : group); })); } if ("function" == typeof substitution) { var _this = this; return _super[Symbol.replace].call(this, str, function () { var args = arguments; return "object" != _typeof(args[args.length - 1]) && (args = [].slice.call(args)).push(buildGroups(args, _this)), substitution.apply(this, args); }); } return _super[Symbol.replace].call(this, str, substitution); }, _wrapRegExp.apply(this, arguments); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Utility for performing math callbacks on a string with CSS units
 * and returning a string with its unit preserved.
 *
 * Example usage:
 * mathWithUnits('4px', (x) => x / 2) = '2px';
 * mathWithUnits(euiTheme.size.xs, (x) => x + 2) = '6px';
 * mathWithUnits([euiTheme.size.l, euiTheme.size.s], (x, y) => x - y) = '16px';
 */
// Unfortunately, this is the CSSProperties[] type used for several euiTheme vars

var mathWithUnits = function mathWithUnits(values, callback) {
  var unit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  if (!Array.isArray(values)) values = [values];
  var foundNumericValues = [];
  var foundUnit = '';
  values.forEach(function (value) {
    if (typeof value === 'string') {
      var _matches$groups, _matches$groups2;
      var regex = /*#__PURE__*/_wrapRegExp(/(\x2D?[\d.]+)(%|[a-zA-Z]*)/, {
        value: 1,
        unit: 2
      });
      var matches = regex.exec(value);
      var numericValue = Number(matches === null || matches === void 0 ? void 0 : (_matches$groups = matches.groups) === null || _matches$groups === void 0 ? void 0 : _matches$groups.value);
      if (!isNaN(numericValue)) {
        foundNumericValues.push(numericValue);
      } else {
        throw new Error('No valid numeric value found');
      }
      if (!unit && matches !== null && matches !== void 0 && (_matches$groups2 = matches.groups) !== null && _matches$groups2 !== void 0 && _matches$groups2.unit) {
        if (!foundUnit) {
          foundUnit = matches.groups.unit;
        } else if (foundUnit !== matches.groups.unit) {
          throw new Error('Multiple units found. Use `calc()` to mix and math multiple unit types (e.g. `%` & `px`) instead');
        }
      }
    } else if (typeof value === 'number') {
      foundNumericValues.push(value);
    } else {
      throw new Error('Invalid value type - pass a string or number');
    }
  });
  return "".concat(callback.apply(void 0, foundNumericValues)).concat(unit || foundUnit);
};
exports.mathWithUnits = mathWithUnits;