"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _beacon = require("../beacon");
var _button = require("../button");
var _flex = require("../flex");
var _i18n = require("../i18n");
var _popover = require("../popover");
var _title = require("../title");
var _tour_step_indicator = require("./tour_step_indicator");
var _services = require("../../services");
var _tour = require("./tour.styles");
var _react2 = require("@emotion/react");
var _excluded = ["anchorPosition", "anchor", "children", "className", "css", "closePopover", "content", "isStepOpen", "minWidth", "maxWidth", "onFinish", "step", "stepsTotal", "style", "subtitle", "title", "decoration", "footerAction", "panelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiTourStep = function EuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
    anchor = _ref.anchor,
    children = _ref.children,
    className = _ref.className,
    css = _ref.css,
    _ref$closePopover = _ref.closePopover,
    closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
    content = _ref.content,
    _ref$isStepOpen = _ref.isStepOpen,
    isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 300 : _ref$minWidth,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? 600 : _ref$maxWidth,
    onFinish = _ref.onFinish,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    stepsTotal = _ref.stepsTotal,
    style = _ref.style,
    subtitle = _ref.subtitle,
    title = _ref.title,
    _ref$decoration = _ref.decoration,
    decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
    footerAction = _ref.footerAction,
    panelProps = _ref.panelProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var titleId = (0, _services.useGeneratedHtmlId)();
  if (step === 0) {
    console.warn('EuiTourStep `step` should 1-based indexing. Please update to eliminate 0 indexes.');
  }
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    anchorNode = _useState2[0],
    setAnchorNode = _useState2[1];
  var _useState3 = (0, _react.useState)(),
    _useState4 = _slicedToArray(_useState3, 2),
    popoverPosition = _useState4[0],
    setPopoverPosition = _useState4[1];
  var onPositionChange = function onPositionChange(position) {
    setPopoverPosition(position);
  };
  (0, _react.useEffect)(function () {
    var timeout;
    if (anchor) {
      // Wait until next tick to find anchor node in case it's not already
      // in DOM requestAnimationFrame isn't used here because we don't need to
      // synchronize with repainting ticks and the updated value still
      // needs to go through a react DOM rerender which may take more than
      // 1 frame (16ms) of time.
      // TODO: It would be ideal to have some kind of intersection observer here instead
      timeout = window.setTimeout(function () {
        setAnchorNode((0, _services.findElementBySelectorOrRef)(anchor));
      });
    }
    return function () {
      timeout && window.clearTimeout(timeout);
    };
  }, [anchor]);
  var classes = (0, _classnames.default)('euiTour', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var tourStyles = (0, _tour.euiTourStyles)(euiTheme);
  var headerStyles = (0, _tour.euiTourHeaderStyles)(euiTheme);
  var footerStyles = (0, _tour.euiTourFooterStyles)(euiTheme);
  var beaconStyles = (0, _tour.euiTourBeaconStyles)(euiTheme);
  var beaconCss = [beaconStyles.euiTourBeacon, isStepOpen && beaconStyles.isOpen, popoverPosition && beaconStyles[popoverPosition]];
  var finishButtonProps = {
    color: 'text',
    flush: 'right',
    size: 'xs'
  };
  var optionalFooterAction = Array.isArray(footerAction) ? (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    wrap: true
  }, footerAction.map(function (action, index) {
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      key: index,
      grow: false
    }, action);
  })) : (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, footerAction);
  var footer = (0, _react2.jsx)(_flex.EuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd',
    alignItems: "center"
  }, stepsTotal > 1 && (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)("ul", {
    className: "euiTourFooter__stepList"
  }, _toConsumableArray(Array(stepsTotal).keys()).map(function (_, i) {
    var status = 'complete';
    if (step === i + 1) {
      status = 'active';
    } else if (step <= i) {
      status = 'incomplete';
    }
    return (0, _react2.jsx)(_tour_step_indicator.EuiTourStepIndicator, {
      key: i,
      number: i + 1,
      status: status
    });
  }))), footerAction ? optionalFooterAction : (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiTourStep.endTour', 'euiTourStep.skipTour', 'euiTourStep.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close tour']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 3),
      endTour = _ref3[0],
      skipTour = _ref3[1],
      closeTour = _ref3[2];
    var content = closeTour;
    if (stepsTotal > 1) {
      content = stepsTotal === step ? endTour : skipTour;
    }
    return (0, _react2.jsx)(_button.EuiButtonEmpty, _extends({
      onClick: onFinish
    }, finishButtonProps), content);
  })));
  var hasBeacon = decoration === 'beacon';
  var popoverProps = _objectSpread({
    anchorPosition: anchorPosition,
    closePopover: closePopover,
    isOpen: isStepOpen,
    ownFocus: false,
    panelClassName: classes,
    panelStyle: style,
    panelProps: _objectSpread(_objectSpread({}, panelProps), {}, {
      css: [tourStyles.euiTour, css, panelProps === null || panelProps === void 0 ? void 0 : panelProps.css]
    }),
    offset: hasBeacon ? 10 : 0,
    'aria-labelledby': titleId,
    arrowChildren: hasBeacon && (0, _react2.jsx)(_beacon.EuiBeacon, {
      css: beaconCss,
      className: "euiTour__beacon"
    }),
    onPositionChange: onPositionChange
  }, rest);
  var layout = (0, _react2.jsx)("div", {
    style: {
      minWidth: minWidth,
      maxWidth: maxWidth
    }
  }, (0, _react2.jsx)(_popover.EuiPopoverTitle, {
    css: headerStyles.euiTourHeader,
    className: "euiTourHeader",
    id: titleId
  }, subtitle && (0, _react2.jsx)(_title.EuiTitle, {
    css: headerStyles.euiTourHeader__subtitle,
    size: "xxxs"
  }, (0, _react2.jsx)("h2", null, subtitle)), (0, _react2.jsx)(_title.EuiTitle, {
    css: headerStyles.euiTourHeader__title,
    size: "xxs"
  }, subtitle ? (0, _react2.jsx)("h3", null, title) : (0, _react2.jsx)("h2", null, title))), (0, _react2.jsx)("div", {
    className: "euiTour__content"
  }, content), (0, _react2.jsx)(_popover.EuiPopoverFooter, {
    css: footerStyles.euiTourFooter,
    className: "euiTourFooter"
  }, footer));
  if (!anchor && children) {
    return (0, _react2.jsx)(_popover.EuiPopover, _extends({
      button: children
    }, popoverProps), layout);
  }
  return anchorNode ? (0, _react2.jsx)(_popover.EuiWrappingPopover, _extends({
    button: anchorNode
  }, popoverProps), layout) : null;
};
exports.EuiTourStep = EuiTourStep;
EuiTourStep.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Element to which the tour step popover attaches when open
       */
  children: _propTypes.default.element,
  anchor: _propTypes.default.any,
  /**
       * Contents of the tour step popover
       */
  content: _propTypes.default.node.isRequired,
  /**
       * Step will display if set to `true`
       */
  isStepOpen: _propTypes.default.bool,
  /**
       * Change the default min width of the popover panel
       */
  minWidth: _propTypes.default.any,
  /**
       * Change the default max width of the popover panel
       */
  maxWidth: _propTypes.default.any,
  /**
       * Function to call for 'Skip tour' and 'End tour' actions
       */
  onFinish: _propTypes.default.func.isRequired,
  /**
       * The number of the step within the parent tour. 1-based indexing.
       */
  step: _propTypes.default.number.isRequired,
  /**
       * The total number of steps in the tour
       */
  stepsTotal: _propTypes.default.number.isRequired,
  /**
       * Optional, standard DOM `style` attribute. Passed to the EuiPopover panel.
       */
  style: _propTypes.default.any,
  /**
       * Smaller title text that appears atop each step in the tour. The subtitle gets wrapped in the appropriate heading level.
       */
  subtitle: _propTypes.default.node,
  /**
       * Larger title text specific to this step. The title gets wrapped in the appropriate heading level.
       */
  title: _propTypes.default.node.isRequired,
  /**
       * Extra visual indication of step location
       */
  decoration: _propTypes.default.oneOf(["none", "beacon"]),
  /**
       * Accepts any `ReactNode` to replace the 'Skip tour' link in the footer.
       * Ideally, pass one button or an array of up to 2 buttons.
       */
  footerAction: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired])
};