"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSkeletonTitleStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _title = require("../title/title.styles");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiSkeletonTitleStyles = function euiSkeletonTitleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSkeletonTitle: /*#__PURE__*/(0, _react.css)("display:block;", (0, _global_styling.logicalCSS)('width', '45%'), " border-radius:", euiTheme.border.radius.medium, ";", (0, _utils.euiSkeletonGradientAnimation)(euiThemeContext), ";;label:euiSkeletonTitle;"),
    // Sizes
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', (0, _title.euiTitle)(euiThemeContext, 'l').lineHeight), ";;label:l;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', (0, _title.euiTitle)(euiThemeContext, 'm').lineHeight), ";;label:m;"),
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', (0, _title.euiTitle)(euiThemeContext, 's').lineHeight), ";;label:s;"),
    xs: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', (0, _title.euiTitle)(euiThemeContext, 'xs').lineHeight), ";;label:xs;"),
    xxs: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', (0, _title.euiTitle)(euiThemeContext, 'xxs').lineHeight), ";;label:xxs;"),
    xxxs: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', (0, _title.euiTitle)(euiThemeContext, 'xxxs').lineHeight), " border-radius:", euiTheme.border.radius.small, ";;label:xxxs;")
  };
};
exports.euiSkeletonTitleStyles = euiSkeletonTitleStyles;